/*
 * Decompiled with CFR 0.152.
 */
package com.speshkitty.playerpronouns;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.speshkitty.playerpronouns.DatabaseData;
import com.speshkitty.playerpronouns.PlayerPronounsConfig;
import com.speshkitty.playerpronouns.PlayerPronounsPlugin;
import com.speshkitty.playerpronouns.Pronoun;
import com.speshkitty.playerpronouns.ResponseObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Friend;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.clan.ClanMember;
import net.runelite.api.clan.ClanSettings;
import net.runelite.client.RuneLite;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.util.Text;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatabaseAPI {
    private static final Logger log = LoggerFactory.getLogger(DatabaseAPI.class);
    private static final MediaType JSON = MediaType.parse((String)"text/json");
    private static final String apiAddress = "https://sx055om2ka.execute-api.eu-west-2.amazonaws.com/publish/";
    private static final String localCacheFolder = RuneLite.RUNELITE_DIR + "/pronouns";
    private static final String localCacheFile = localCacheFolder + "/pronouns.json";
    private HashMap<String, DatabaseData> knownPronouns = new HashMap();
    private boolean cacheIsDirty = false;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private PlayerPronounsConfig config;
    private final PlayerPronounsPlugin playerPronounsPlugin;
    @Inject
    private ChatMessageManager chatMessageManager;
    Type typeMyType = new TypeToken<HashMap<String, DatabaseData>>(){}.getType();

    @Inject
    DatabaseAPI(PlayerPronounsPlugin playerPronounsPlugin) {
        this.playerPronounsPlugin = playerPronounsPlugin;
        this.tryCreateFile();
    }

    protected void destroy() {
        this.knownPronouns = new HashMap();
        this.cacheIsDirty = false;
    }

    private void tryCreateFile() {
        try {
            if (new File(localCacheFolder).mkdir()) {
                log.debug("Created folder: " + localCacheFolder);
            }
            if (new File(localCacheFile).createNewFile()) {
                log.debug("Created file: " + localCacheFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String findUserPronouns(String username) {
        String hashedName = this.hashString(username);
        if (this.knownPronouns.containsKey(hashedName)) {
            DatabaseData data = this.knownPronouns.get(hashedName);
            if (data == null || data.getPronoun() == null) {
                return "";
            }
            return this.knownPronouns.get(hashedName).getPronoun();
        }
        return "";
    }

    protected void getData() {
        this.tryCreateFile();
        if (this.knownPronouns.size() == 0) {
            this.readFromFile();
            log.debug("Read " + this.knownPronouns.size() + " items from file!");
        }
        this.readFromServer();
    }

    private void readFromFile() {
        try {
            FileReader reader = new FileReader(localCacheFile);
            this.knownPronouns = (HashMap)this.gson.fromJson((Reader)reader, this.typeMyType);
            if (this.knownPronouns == null) {
                this.knownPronouns = new HashMap();
                return;
            }
            this.cacheIsDirty = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void readFromServer() {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.playerPronounsPlugin.getPlayerNameHashed().isEmpty()) {
            return;
        }
        ArrayList<String> playersToLookup = new ArrayList<String>();
        playersToLookup.addAll(this.addCachedPlayers());
        playersToLookup.addAll(this.addClanPlayers(this.client.getClanSettings()));
        playersToLookup.addAll(this.addClanPlayers(this.client.getGuestClanSettings()));
        playersToLookup.addAll(this.addFriendsChatPlayers());
        playersToLookup.addAll(this.addFriendsList());
        if (playersToLookup.size() == 0) {
            return;
        }
        JsonArray array = this.gson.toJsonTree((Object)playersToLookup.toArray()).getAsJsonArray();
        JsonObject data = new JsonObject();
        data.addProperty("senderUsername", this.playerPronounsPlugin.getPlayerNameHashed());
        data.add("usernames", (JsonElement)array);
        log.debug(data.toString());
        RequestBody body = RequestBody.create((MediaType)JSON, (String)data.toString());
        Request request = new Request.Builder().url(apiAddress).post(body).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (response.body() == null) {
                return;
            }
            String responseString = response.body().string();
            if (responseString.contains("errorMessage")) {
                return;
            }
            ResponseObject responseObject = (ResponseObject)this.gson.fromJson(responseString, ResponseObject.class);
            playersToLookup.forEach(s -> {
                int val = responseObject.findIndex((String)s);
                if (val == -1) {
                    this.knownPronouns.putIfAbsent((String)s, new DatabaseData(Instant.now().getEpochSecond(), null));
                } else {
                    this.knownPronouns.putIfAbsent((String)s, new DatabaseData(Instant.now().getEpochSecond(), responseObject.getBody().get(val).getPronoun()));
                }
                this.cacheIsDirty = true;
            });
        }
        catch (IOException e) {
            log.error("Error communicating with server!");
        }
        this.saveDataToFile();
    }

    private List<String> addCachedPlayers() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Player cachedPlayer : this.client.getCachedPlayers()) {
            String hashedTarget;
            if (cachedPlayer == null || !this.shouldAddNameToLookup(hashedTarget = this.hashString(cachedPlayer.getName()))) continue;
            toReturn.add(hashedTarget);
        }
        return toReturn;
    }

    private List<String> addClanPlayers(ClanSettings clan) {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (clan == null) {
            return toReturn;
        }
        for (ClanMember clanMember : clan.getMembers()) {
            String hashedTarget;
            if (clanMember == null || !this.shouldAddNameToLookup(hashedTarget = this.hashString(clanMember.getName()))) continue;
            toReturn.add(hashedTarget);
        }
        return toReturn;
    }

    private List<String> addFriendsChatPlayers() {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (this.client.getFriendsChatManager() == null) {
            return toReturn;
        }
        for (FriendsChatMember friendsChatMember : (FriendsChatMember[])this.client.getFriendsChatManager().getMembers()) {
            String hashedTarget;
            if (friendsChatMember == null || !this.shouldAddNameToLookup(hashedTarget = this.hashString(friendsChatMember.getName()))) continue;
            toReturn.add(hashedTarget);
        }
        return toReturn;
    }

    private List<String> addFriendsList() {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (this.client.getFriendContainer() == null) {
            return toReturn;
        }
        for (Friend friend : (Friend[])this.client.getFriendContainer().getMembers()) {
            String hashedTarget;
            if (friend == null || !this.shouldAddNameToLookup(hashedTarget = this.hashString(friend.getName()))) continue;
            toReturn.add(hashedTarget);
        }
        return toReturn;
    }

    private boolean shouldAddNameToLookup(String name) {
        return !this.knownPronouns.containsKey(name);
    }

    protected void putPlayersPronoun(Pronoun oldPronoun, boolean isLoginTriggered) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.playerPronounsPlugin.getPlayerNameHashed().isEmpty()) {
            return;
        }
        int pronounToPut = this.config.presetPronoun().getInternalValue();
        String apiKey = this.configManager.getConfiguration("playerpronouns", "apikey." + this.playerPronounsPlugin.getPlayerNameHashed());
        JsonObject data = new JsonObject();
        data.addProperty("username", this.playerPronounsPlugin.getPlayerNameHashed());
        data.addProperty("pronoun", (Number)pronounToPut);
        if (apiKey != null && !apiKey.isEmpty()) {
            data.addProperty("apikey", apiKey);
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)data.toString());
        log.debug(data.toString());
        Request request = new Request.Builder().url(apiAddress).put(body).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            String responseMessage;
            if (response.body() == null) {
                return;
            }
            JsonObject responseData = (JsonObject)this.gson.fromJson(response.body().string(), JsonObject.class);
            JsonPrimitive statusCodePrim = responseData.getAsJsonPrimitive("statusCode");
            JsonPrimitive responseMessagePrim = responseData.getAsJsonPrimitive("body");
            int statusCode = statusCodePrim == null ? 430 : statusCodePrim.getAsInt();
            String string = responseMessage = responseMessagePrim == null ? "" : responseMessagePrim.getAsString();
            if (responseData.has("apikey")) {
                this.configManager.setConfiguration("playerpronouns", "apikey." + this.playerPronounsPlugin.getPlayerNameHashed(), responseData.getAsJsonPrimitive("apikey").getAsString());
                this.sendMessage("API key has been received and set, and is stored in your RuneLite config. Do not share this!");
                this.sendMessage("If you lose this, you will not be able to update your pronoun until it is removed from the database!");
            }
            if (statusCode == 200) {
                if (!isLoginTriggered) {
                    this.sendMessage(responseMessage);
                }
            } else {
                if (!isLoginTriggered) {
                    this.sendMessage("Error " + statusCode + " - " + responseMessage);
                }
                this.resetPronounConfig(oldPronoun);
            }
        }
        catch (IOException e) {
            log.error("Error putting data to server!");
        }
    }

    private void resetPronounConfig(Pronoun pronoun) {
        this.playerPronounsPlugin.shouldUpdateConfig = false;
        this.configManager.setConfiguration("playerpronouns", "presetPronoun", (Object)pronoun);
        this.playerPronounsPlugin.shouldUpdateConfig = true;
    }

    protected void cleanUpData() {
        for (Map.Entry<String, DatabaseData> value : new HashMap<String, DatabaseData>(this.knownPronouns).entrySet()) {
            Instant timeCreated = Instant.ofEpochSecond(value.getValue().getRetrievedAt());
            Instant destroyAfter = value.getValue().getPronoun() == null || value.getValue().getPronoun().isEmpty() ? timeCreated.plus(Period.ofDays(1)) : timeCreated.plus(Period.ofDays(14));
            if (!Instant.now().isAfter(destroyAfter)) continue;
            this.knownPronouns.remove(value.getKey());
            this.cacheIsDirty = true;
        }
        this.saveDataToFile();
    }

    protected void saveDataToFile() {
        if (!this.cacheIsDirty) {
            return;
        }
        this.tryCreateFile();
        try {
            HashMap toSave = new HashMap();
            this.knownPronouns.forEach((hashedName, data) -> {
                if (data != null && data.getPronoun() != null && !data.getPronoun().isEmpty()) {
                    toSave.put(hashedName, data);
                }
            });
            String jsonData = this.gson.toJson(toSave);
            FileWriter dataFile = new FileWriter(localCacheFile);
            dataFile.write(jsonData);
            dataFile.close();
            this.cacheIsDirty = false;
        }
        catch (IOException e) {
            log.error("Error saving data!");
            e.printStackTrace();
        }
    }

    private void sendMessage(String message) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    String hashString(String input) {
        if (input == null) {
            return "";
        }
        String cleanedName = Text.removeTags((String)input);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hash = digest.digest(cleanedName.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

