/*
 * Decompiled with CFR 0.152.
 */
package com.brooklyn.tobnoticeboard;

import com.brooklyn.tobnoticeboard.TobNoticeBoardConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.FriendContainer;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.NameableContainer;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToB Notice Board", description="Highlight friends and clan members on the Theatre of Blood Notice Board", tags={"theatre, theater, pvm, combat, party, friend, clan, cc, fc, friendschat, clanchat, raids, hub, brooklyn"})
public class TobNoticeBoardPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TobNoticeBoardPlugin.class);
    private static final int DEFAULT_RGB = 16750623;
    @Inject
    private Client client;
    @Inject
    private TobNoticeBoardConfig config;
    @Inject
    private ClientThread clientThread;

    public void startUp() {
        this.setNoticeBoard();
    }

    public void shutDown() {
        this.unsetNoticeBoard();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("tobnoticeboard")) {
            this.setNoticeBoard();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        this.clientThread.invokeLater(() -> {
            if (widgetLoaded.getGroupId() == 364) {
                this.setNoticeBoard();
            }
        });
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 631 || event.getScriptId() == 630) {
            this.setNoticeBoard();
        }
    }

    private void setNameColors(int friendColor, int clanColor, int ignoreColor) {
        for (int childID = 17; childID < 62; ++childID) {
            Widget noticeBoard = this.client.getWidget(364, childID);
            if (noticeBoard == null || noticeBoard.getName() == null || noticeBoard.getChildren() == null) continue;
            for (Widget noticeBoardChild : noticeBoard.getChildren()) {
                if (noticeBoardChild.getIndex() != 3) continue;
                NameableContainer ignoreContainer = this.client.getIgnoreContainer();
                FriendContainer friendContainer = this.client.getFriendContainer();
                if (ignoreContainer.findByName(Text.removeTags((String)noticeBoard.getName())) != null) {
                    noticeBoardChild.setTextColor(this.config.highlightIgnored() ? ignoreColor : 16750623);
                    continue;
                }
                if (friendContainer.findByName(Text.removeTags((String)noticeBoard.getName())) != null) {
                    noticeBoardChild.setTextColor(this.config.highlightFriends() ? friendColor : 16750623);
                    continue;
                }
                if (this.client.getFriendsChatManager() == null) continue;
                for (FriendsChatMember member : (FriendsChatMember[])this.client.getFriendsChatManager().getMembers()) {
                    if (!Text.toJagexName((String)member.getName()).equals(Text.removeTags((String)noticeBoard.getName()))) continue;
                    noticeBoardChild.setTextColor(this.config.highlightClan() ? clanColor : 16750623);
                }
            }
        }
    }

    private void setNoticeBoard() {
        this.setNameColors(this.config.friendColor().getRGB(), this.config.clanColor().getRGB(), this.config.ignoredColor().getRGB());
    }

    private void unsetNoticeBoard() {
        this.setNameColors(16750623, 16750623, 16750623);
    }

    @Provides
    TobNoticeBoardConfig provideConfig(ConfigManager configManager) {
        return (TobNoticeBoardConfig)configManager.getConfig(TobNoticeBoardConfig.class);
    }
}

