/*
 * Decompiled with CFR 0.152.
 */
package com.weaponcharges;

import com.google.inject.Inject;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetUtil;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogTracker
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(DialogTracker.class);
    private static final int COMPONENT_ID_DIALOG_PLAYER_CLICK_HERE_TO_CONTINUE = 5;
    private static final int COMPONENT_ID_DIALOG_NPC_CLICK_HERE_TO_CONTINUE = 5;
    private static final int COMPONENT_ID_DIALOG_PLAYER_NAME = 4;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private Consumer<DialogState> dialogStateChanged;
    private BiConsumer<DialogState, String> dialogOptionSelected;
    private DialogState lastDialogState = null;
    private boolean optionSelected = false;

    public void setStateChangedListener(Consumer<DialogState> listener) {
        this.dialogStateChanged = listener;
    }

    public void setOptionSelectedListener(BiConsumer<DialogState, String> listener) {
        this.dialogOptionSelected = listener;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        int widgetId = event.getParam1();
        int interfaceId = WidgetUtil.componentToInterface((int)widgetId);
        int componentId = WidgetUtil.componentToId((int)widgetId);
        if (widgetId == 14352385) {
            Widget widget = this.client.getWidget(14352385);
            int dynamicChildIndex = event.getParam0();
            Widget[] dynamicChildren = widget.getDynamicChildren();
            Widget dynamicChild = dynamicChildren[dynamicChildIndex];
            if (dynamicChild == null) {
                log.debug("dynamic child option was null, index " + dynamicChildIndex + " total children: " + dynamicChildren.length);
                return;
            }
            this.optionSelected(this.lastDialogState, dynamicChild.getText());
        } else if (interfaceId == 231 && componentId == 5) {
            this.optionSelected(this.lastDialogState, null);
        } else if (interfaceId == 217 && componentId == 5) {
            this.optionSelected(this.lastDialogState, null);
        } else if (interfaceId == 193 && componentId == 0) {
            this.optionSelected(this.lastDialogState, null);
        }
    }

    public DialogState getDialogState() {
        DialogState state;
        DialogState.DialogType type = this.getDialogType();
        switch (type) {
            case NPC: {
                Widget nameWidget = this.client.getWidget(15138820);
                Widget textWidget = this.client.getWidget(15138822);
                String name = nameWidget != null ? nameWidget.getText() : null;
                String text = textWidget != null ? textWidget.getText() : null;
                state = DialogState.npc(name, text);
                break;
            }
            case PLAYER: {
                Widget nameWidget = this.client.getWidget(217, 4);
                Widget textWidget = this.client.getWidget(14221318);
                String name = nameWidget != null ? nameWidget.getText() : null;
                String text = textWidget != null ? textWidget.getText() : null;
                state = DialogState.player(name, text);
                break;
            }
            case OPTIONS: {
                String text = null;
                Widget optionsWidget = this.client.getWidget(14352385);
                ArrayList<String> options = null;
                if (optionsWidget != null) {
                    options = new ArrayList<String>();
                    for (Widget child : optionsWidget.getDynamicChildren()) {
                        if (child.getText() == null || child.getText().isEmpty()) continue;
                        options.add(child.getText());
                    }
                    text = (String)options.remove(0);
                }
                state = DialogState.options(text, options);
                break;
            }
            case SPRITE: {
                Widget textWidget = this.client.getWidget(12648450);
                String text = textWidget != null ? textWidget.getText() : null;
                Widget itemWidget = this.client.getWidget(0xC10001);
                int itemId = itemWidget != null ? itemWidget.getItemId() : -1;
                state = DialogState.sprite(text, itemId);
                break;
            }
            case INPUT: {
                Widget titleWidget = this.client.getWidget(10616873);
                String title = titleWidget != null ? titleWidget.getText() : null;
                String input = this.client.getVarcStrValue(359);
                state = DialogState.input(title, input);
                break;
            }
            case NO_DIALOG: {
                state = DialogState.noDialog();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + type);
            }
        }
        return state;
    }

    private DialogState.DialogType getDialogType() {
        Widget npcDialog = this.client.getWidget(231, 0);
        if (npcDialog != null && !npcDialog.isHidden()) {
            return DialogState.DialogType.NPC;
        }
        Widget playerDialog = this.client.getWidget(217, 0);
        if (playerDialog != null && !playerDialog.isHidden()) {
            return DialogState.DialogType.PLAYER;
        }
        Widget optionsDialog = this.client.getWidget(219, 0);
        if (optionsDialog != null && !optionsDialog.isHidden()) {
            return DialogState.DialogType.OPTIONS;
        }
        Widget spriteDialog = this.client.getWidget(193, 0);
        if (spriteDialog != null && !spriteDialog.isHidden()) {
            return DialogState.DialogType.SPRITE;
        }
        Widget inputDialog = this.client.getWidget(0xA2002A);
        if (inputDialog != null && !inputDialog.isHidden()) {
            return DialogState.DialogType.INPUT;
        }
        return DialogState.DialogType.NO_DIALOG;
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.optionSelected = false;
        DialogState dialogState = this.getDialogState();
        if (!Objects.equals(dialogState, this.lastDialogState)) {
            log.debug("dialog changed: {} previous: {} (game tick: {})", new Object[]{dialogState, this.lastDialogState, this.client.getTickCount()});
            if (this.dialogStateChanged != null) {
                this.dialogStateChanged.accept(dialogState);
            }
        }
        this.lastDialogState = dialogState;
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        Widget dynamicChild;
        Widget w;
        if (event.getScriptId() == 2153) {
            Widget w2 = this.client.getWidget(14352385);
            if (w2 != null && !w2.isHidden()) {
                for (int i = 0; i < w2.getDynamicChildren().length; ++i) {
                    Widget dynamicChild2 = w2.getDynamicChildren()[i];
                    if (!"Please wait...".equals(Text.removeTags((String)dynamicChild2.getText()))) continue;
                    String option = null;
                    if (this.lastDialogState.type == DialogState.DialogType.OPTIONS && this.lastDialogState.options != null && this.lastDialogState.options.size() > i - 1) {
                        option = this.lastDialogState.options.get(i - 1);
                    }
                    this.optionSelected(this.lastDialogState, option);
                }
            }
            if ((w2 = this.client.getWidget(231, 5)) != null && !w2.isHidden() && "Please wait...".equals(Text.removeTags((String)w2.getText()))) {
                this.optionSelected(this.lastDialogState, null);
            }
            if ((w2 = this.client.getWidget(217, 5)) != null && !w2.isHidden() && "Please wait...".equals(Text.removeTags((String)w2.getText()))) {
                this.optionSelected(this.lastDialogState, null);
            }
        } else if (event.getScriptId() == 2869 && (w = this.client.getWidget(193, 0)) != null && !w.isHidden() && "Please wait...".equals(Text.removeTags((String)(dynamicChild = w.getDynamicChildren()[2]).getText()))) {
            this.optionSelected(this.lastDialogState, null);
        }
    }

    private void optionSelected(DialogState state, String option) {
        if (this.optionSelected) {
            return;
        }
        this.optionSelected = true;
        if (state.type == DialogState.DialogType.OPTIONS) {
            log.debug("option selected: \"" + option + "\" " + state);
        } else {
            log.debug("clicked here to continue: " + state);
        }
        if (this.dialogOptionSelected != null) {
            this.dialogOptionSelected.accept(state, option);
        }
    }

    public void reset() {
        this.lastDialogState = null;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        try {
            if (e.getKeyCode() == 10) {
                this.clientThread.invoke(() -> {
                    String inputText = this.client.getVarcStrValue(359);
                    if (this.lastDialogState.type == DialogState.DialogType.INPUT) {
                        this.optionSelected(this.lastDialogState, inputText);
                    }
                });
            }
        }
        catch (RuntimeException ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public static class DialogState {
        @NonNull
        final DialogType type;
        @Nullable
        final String name;
        @Nullable
        final String text;
        @Nullable
        final Integer spriteDialogItemId;
        @Nullable
        final List<String> options;

        public static DialogState sprite(String text, int itemId) {
            return new DialogState(DialogType.SPRITE, null, text, itemId, null);
        }

        public static DialogState player(String name, String text) {
            return new DialogState(DialogType.PLAYER, name, text, null, null);
        }

        public static DialogState npc(String name, String text) {
            return new DialogState(DialogType.NPC, name, text, null, null);
        }

        public static DialogState options(String text, List<String> options) {
            return new DialogState(DialogType.OPTIONS, null, text, null, options);
        }

        public static DialogState options(String text, String ... options) {
            return new DialogState(DialogType.OPTIONS, null, text, null, Arrays.asList(options));
        }

        public static DialogState input(String title, String input) {
            return new DialogState(DialogType.INPUT, title, input, null, null);
        }

        public static DialogState noDialog() {
            return new DialogState(DialogType.NO_DIALOG, null, null, null, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DialogState that = (DialogState)o;
            return this.type == that.type && Objects.equals(this.text, that.text) && Objects.equals(this.name, that.name) && Objects.equals(this.options, that.options);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.text, this.name, this.options});
        }

        public String toString() {
            switch (this.type) {
                case NO_DIALOG: {
                    return "DialogState{" + this.type + "}";
                }
                case NPC: 
                case PLAYER: {
                    return "DialogState{" + this.type + ", name='" + this.name + "', text='" + this.text + "'}";
                }
                case SPRITE: {
                    return "DialogState{" + this.type + ", text='" + this.text + "', itemId=" + this.spriteDialogItemId + "}";
                }
                case OPTIONS: {
                    return "DialogState{" + this.type + ", text='" + this.text + "', options=" + this.options + "}";
                }
                case INPUT: {
                    return "DialogState{" + this.type + ", title='" + this.name + "', input='" + this.text + "'}";
                }
            }
            throw new IllegalStateException();
        }

        public DialogState(@NonNull DialogType type, @Nullable String name, @Nullable String text, @Nullable Integer spriteDialogItemId, @Nullable List<String> options) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            this.name = name;
            this.text = text;
            this.spriteDialogItemId = spriteDialogItemId;
            this.options = options;
        }

        static enum DialogType {
            NO_DIALOG,
            PLAYER,
            NPC,
            OPTIONS,
            SPRITE,
            INPUT;

        }
    }
}

