/*
 * Decompiled with CFR 0.152.
 */
package com.weaponcharges;

import com.weaponcharges.DialogTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.client.util.Text;

public class DialogStateMatcher {
    private final boolean isOptionSelected;
    private final DialogTracker.DialogState.DialogType type;
    private final Pattern nameMatch;
    private final Pattern textMatch;
    private final Integer spriteDialogId;
    private final List<Pattern> optionMatches;
    private final Pattern optionMatch;

    public static DialogStateMatcher sprite(Pattern textMatch, Integer itemId) {
        return DialogStateMatcher.sprite(textMatch, itemId, false);
    }

    public static DialogStateMatcher spriteOptionSelected(Pattern textMatch, Integer itemId) {
        return DialogStateMatcher.sprite(textMatch, itemId, true);
    }

    private static DialogStateMatcher sprite(Pattern textMatch, Integer itemId, boolean isOptionSelected) {
        return DialogStateMatcher.builder().type(DialogTracker.DialogState.DialogType.SPRITE).isOptionSelected(isOptionSelected).textMatch(textMatch).spriteDialogId(itemId).build();
    }

    public static DialogStateMatcher player(Pattern textMatch, Pattern nameMatch) {
        return DialogStateMatcher.player(textMatch, nameMatch, false);
    }

    public static DialogStateMatcher playerOptionSelected(Pattern textMatch, Pattern nameMatch) {
        return DialogStateMatcher.player(textMatch, nameMatch, true);
    }

    private static DialogStateMatcher player(Pattern textMatch, Pattern nameMatch, boolean isOptionSelected) {
        return DialogStateMatcher.builder().type(DialogTracker.DialogState.DialogType.PLAYER).isOptionSelected(isOptionSelected).nameMatch(nameMatch).textMatch(textMatch).build();
    }

    public static DialogStateMatcher npc(Pattern textMatch, Pattern nameMatch) {
        return DialogStateMatcher.npc(textMatch, nameMatch, false);
    }

    public static DialogStateMatcher npcOptionSelected(Pattern textMatch, Pattern nameMatch) {
        return DialogStateMatcher.npc(textMatch, nameMatch, true);
    }

    private static DialogStateMatcher npc(Pattern textMatch, Pattern nameMatch, boolean isOptionSelected) {
        return DialogStateMatcher.builder().type(DialogTracker.DialogState.DialogType.NPC).isOptionSelected(isOptionSelected).nameMatch(nameMatch).textMatch(textMatch).build();
    }

    public static DialogStateMatcher options(Pattern textMatch, List<Pattern> optionsMatch) {
        return DialogStateMatcher.options(textMatch, optionsMatch, null, false);
    }

    public static DialogStateMatcher optionsOptionSelected(Pattern textMatch, List<Pattern> optionsMatch, Pattern optionSelectedMatch) {
        return DialogStateMatcher.options(textMatch, optionsMatch, optionSelectedMatch, true);
    }

    private static DialogStateMatcher options(Pattern textMatch, List<Pattern> optionsMatch, Pattern optionSelectedMatch, boolean isOptionSelected) {
        return DialogStateMatcher.builder().type(DialogTracker.DialogState.DialogType.OPTIONS).isOptionSelected(isOptionSelected).textMatch(textMatch).optionMatches(optionsMatch).optionMatch(optionSelectedMatch).build();
    }

    public static DialogStateMatcher input(Pattern textMatch) {
        return DialogStateMatcher.input(textMatch, null, false);
    }

    public static DialogStateMatcher inputOptionSelected(Pattern textMatch, Pattern optionSelectedMatcher) {
        return DialogStateMatcher.input(textMatch, optionSelectedMatcher, true);
    }

    private static DialogStateMatcher input(Pattern textMatch, Pattern optionSelectedMatcher, boolean isOptionSelected) {
        return DialogStateMatcher.builder().type(DialogTracker.DialogState.DialogType.INPUT).isOptionSelected(isOptionSelected).nameMatch(textMatch).build();
    }

    public DialogStateMatchers matchDialog(DialogTracker.DialogState dialogState) {
        return this.matchDialog(dialogState, false, null);
    }

    public DialogStateMatchers matchDialogOptionSelected(DialogTracker.DialogState dialogState, String isOptionSelected) {
        return this.matchDialog(dialogState, true, isOptionSelected);
    }

    private DialogStateMatchers matchDialog(DialogTracker.DialogState dialogState, boolean isOptionSelected, String optionSelected) {
        if (this.isOptionSelected != isOptionSelected) {
            return null;
        }
        if (this.getType() != dialogState.type) {
            return null;
        }
        if (this.getSpriteDialogId() != null && this.getSpriteDialogId() != dialogState.spriteDialogItemId) {
            return null;
        }
        Matcher nameMatcher = null;
        if (this.getNameMatch() != null) {
            if (dialogState.name == null) {
                return null;
            }
            nameMatcher = this.getNameMatch().matcher(dialogState.name);
            if (!nameMatcher.find()) {
                return null;
            }
        }
        Matcher textMatcher = null;
        String text = dialogState.text;
        text = Text.removeTags((String)text.replaceAll("<br>", " "));
        if (this.getTextMatch() != null) {
            if (text == null) {
                return null;
            }
            textMatcher = this.getTextMatch().matcher(text);
            if (!textMatcher.find()) {
                return null;
            }
        }
        ArrayList<Matcher> optionMatchers = new ArrayList<Matcher>();
        if (this.getOptionMatches() != null) {
            if (this.getOptionMatches().size() != dialogState.options.size()) {
                return null;
            }
            for (int i = 0; i < this.getOptionMatches().size(); ++i) {
                Pattern optionMatch = this.getOptionMatches().get(i);
                if (optionMatch == null) {
                    optionMatchers.add(null);
                    continue;
                }
                String option = dialogState.options.get(i);
                if (option == null) {
                    return null;
                }
                Matcher optionMatcher = optionMatch.matcher(option);
                if (!optionMatcher.find()) {
                    return null;
                }
                optionMatchers.add(optionMatcher);
            }
        }
        Matcher optionMatcher = null;
        if (this.getOptionMatch() != null) {
            if (optionSelected == null) {
                return null;
            }
            optionMatcher = this.getOptionMatch().matcher(optionSelected);
            if (!optionMatcher.find()) {
                return null;
            }
        }
        return new DialogStateMatchers(nameMatcher, textMatcher, dialogState.spriteDialogItemId, optionMatchers, optionMatcher);
    }

    DialogStateMatcher(boolean isOptionSelected, DialogTracker.DialogState.DialogType type, Pattern nameMatch, Pattern textMatch, Integer spriteDialogId, List<Pattern> optionMatches, Pattern optionMatch) {
        this.isOptionSelected = isOptionSelected;
        this.type = type;
        this.nameMatch = nameMatch;
        this.textMatch = textMatch;
        this.spriteDialogId = spriteDialogId;
        this.optionMatches = optionMatches;
        this.optionMatch = optionMatch;
    }

    public static DialogStateMatcherBuilder builder() {
        return new DialogStateMatcherBuilder();
    }

    public boolean isOptionSelected() {
        return this.isOptionSelected;
    }

    public DialogTracker.DialogState.DialogType getType() {
        return this.type;
    }

    public Pattern getNameMatch() {
        return this.nameMatch;
    }

    public Pattern getTextMatch() {
        return this.textMatch;
    }

    public Integer getSpriteDialogId() {
        return this.spriteDialogId;
    }

    public List<Pattern> getOptionMatches() {
        return this.optionMatches;
    }

    public Pattern getOptionMatch() {
        return this.optionMatch;
    }

    public static class DialogStateMatcherBuilder {
        private boolean isOptionSelected;
        private DialogTracker.DialogState.DialogType type;
        private Pattern nameMatch;
        private Pattern textMatch;
        private Integer spriteDialogId;
        private List<Pattern> optionMatches;
        private Pattern optionMatch;

        DialogStateMatcherBuilder() {
        }

        public DialogStateMatcherBuilder isOptionSelected(boolean isOptionSelected) {
            this.isOptionSelected = isOptionSelected;
            return this;
        }

        public DialogStateMatcherBuilder type(DialogTracker.DialogState.DialogType type) {
            this.type = type;
            return this;
        }

        public DialogStateMatcherBuilder nameMatch(Pattern nameMatch) {
            this.nameMatch = nameMatch;
            return this;
        }

        public DialogStateMatcherBuilder textMatch(Pattern textMatch) {
            this.textMatch = textMatch;
            return this;
        }

        public DialogStateMatcherBuilder spriteDialogId(Integer spriteDialogId) {
            this.spriteDialogId = spriteDialogId;
            return this;
        }

        public DialogStateMatcherBuilder optionMatches(List<Pattern> optionMatches) {
            this.optionMatches = optionMatches;
            return this;
        }

        public DialogStateMatcherBuilder optionMatch(Pattern optionMatch) {
            this.optionMatch = optionMatch;
            return this;
        }

        public DialogStateMatcher build() {
            return new DialogStateMatcher(this.isOptionSelected, this.type, this.nameMatch, this.textMatch, this.spriteDialogId, this.optionMatches, this.optionMatch);
        }

        public String toString() {
            return "DialogStateMatcher.DialogStateMatcherBuilder(isOptionSelected=" + this.isOptionSelected + ", type=" + this.type + ", nameMatch=" + this.nameMatch + ", textMatch=" + this.textMatch + ", spriteDialogId=" + this.spriteDialogId + ", optionMatches=" + this.optionMatches + ", optionMatch=" + this.optionMatch + ")";
        }
    }

    public static final class DialogStateMatchers {
        private final Matcher nameMatcher;
        private final Matcher textMatcher;
        private final Integer spriteDialogId;
        private final List<Matcher> optionMatchers;
        private final Matcher optionMatch;

        public Matcher getNameMatcher() {
            return this.nameMatcher;
        }

        public Matcher getTextMatcher() {
            return this.textMatcher;
        }

        public Integer getSpriteDialogId() {
            return this.spriteDialogId;
        }

        public List<Matcher> getOptionMatchers() {
            return this.optionMatchers;
        }

        public Matcher getOptionMatch() {
            return this.optionMatch;
        }

        public DialogStateMatchers(Matcher nameMatcher, Matcher textMatcher, Integer spriteDialogId, List<Matcher> optionMatchers, Matcher optionMatch) {
            this.nameMatcher = nameMatcher;
            this.textMatcher = textMatcher;
            this.spriteDialogId = spriteDialogId;
            this.optionMatchers = optionMatchers;
            this.optionMatch = optionMatch;
        }
    }
}

