/*
 * Decompiled with CFR 0.152.
 */
package com.weaponcharges;

import com.weaponcharges.ChargedWeapon;
import com.weaponcharges.DialogTracker;
import com.weaponcharges.WeaponChargesPlugin;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.CommandExecuted;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Devtools {
    private static final Logger log = LoggerFactory.getLogger(Devtools.class);
    private final WeaponChargesPlugin plugin;

    public Devtools(WeaponChargesPlugin plugin) {
        this.plugin = plugin;
    }

    private void message(String message) {
        log.info(this.plugin.client.getTickCount() + ": " + message);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE || chatMessage.getType() == ChatMessageType.SPAM) {
            this.message(chatMessage.getType() + " \"" + chatMessage.getMessage() + "\"");
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged animationChanged) {
        if (animationChanged.getActor().equals(this.plugin.client.getLocalPlayer())) {
            this.message("animation changed: " + animationChanged.getActor().getAnimation());
        }
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        if ("setcharges".equals(commandExecuted.getCommand())) {
            String weapon = commandExecuted.getArguments()[0];
            String key = this.getKey(weapon);
            System.out.println("setting " + key + " to " + commandExecuted.getArguments()[1]);
            this.plugin.configManager.setRSProfileConfiguration("weaponCharges", key, (Object)commandExecuted.getArguments()[1]);
        } else if ("unsetcharges".equals(commandExecuted.getCommand())) {
            String weapon = commandExecuted.getArguments()[0];
            String key = this.getKey(weapon);
            System.out.println("unsetting " + key);
            this.plugin.configManager.unsetRSProfileConfiguration("weaponCharges", key);
        }
    }

    private String getKey(String weapon) {
        switch (weapon) {
            case "bpscales": {
                return "blowpipeScales";
            }
            case "bpdarts": {
                return "blowpipeDarts";
            }
            case "swamp": {
                return ChargedWeapon.TRIDENT_OF_THE_SWAMP.configKeyName;
            }
            case "seas": {
                return ChargedWeapon.TRIDENT_OF_THE_SEAS.configKeyName;
            }
            case "ibans": {
                return ChargedWeapon.IBANS_STAFF.configKeyName;
            }
            case "chally": {
                return ChargedWeapon.CRYSTAL_HALBERD.configKeyName;
            }
            case "tent": {
                return ChargedWeapon.ABYSSAL_TENTACLE.configKeyName;
            }
            case "tome": {
                return ChargedWeapon.TOME_OF_FIRE.configKeyName;
            }
            case "serp": {
                return ChargedWeapon.SERPENTINE_HELM.configKeyName;
            }
        }
        return null;
    }

    public void dialogStateChanged(DialogTracker.DialogState dialogState) {
        this.message("dialog state changed: " + dialogState);
    }

    public void optionSelected(DialogTracker.DialogState dialogState, String s) {
        this.message("option selected: \"" + s + "\" from " + dialogState);
    }
}

