/*
 * Decompiled with CFR 0.152.
 */
package com.weaponcharges;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChargesMessage {
    private final Pattern pattern;
    private final Function<Matcher, Integer> chargeLeft;

    public int getChargesLeft(Matcher matcher) {
        return this.chargeLeft.apply(matcher);
    }

    public static ChargesMessage staticChargeMessage(String s, int charges) {
        return new ChargesMessage(Pattern.compile(s), matcher -> charges);
    }

    public static ChargesMessage matcherGroupChargeMessage(String s, int group) {
        return new ChargesMessage(Pattern.compile(s), matcher -> {
            String chargeCountString = matcher.group(group).replaceAll(",", "");
            return Integer.parseInt(chargeCountString);
        });
    }

    public ChargesMessage(Pattern pattern, Function<Matcher, Integer> chargeLeft) {
        this.pattern = pattern;
        this.chargeLeft = chargeLeft;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

