/*
 * Decompiled with CFR 0.152.
 */
package psyda.banktabnames;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psyda.banktabnames.BankTabNamesConfig;

@PluginDescriptor(name="Bank Tab Names", description="Customize your bank tabs with custom styled names", tags={"bank", "tab", "name", "custom", "edit", "psyda"})
public class BankTabNamesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankTabNamesPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private BankTabNamesConfig config;
    private static final int TAB_MAX_LENGTH = 15;

    @Provides
    BankTabNamesConfig getConfig(ConfigManager configManager) {
        return (BankTabNamesConfig)configManager.getConfig(BankTabNamesConfig.class);
    }

    protected void startUp() throws Exception {
        this.clientThread.invoke(this::replaceBankTabNumbers);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.replaceBankTabNumbers();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (scriptPostFired.getScriptId() == 504 || scriptPostFired.getScriptId() == 276 || scriptPostFired.getScriptId() == 3275) {
            this.replaceBankTabNumbers();
        }
    }

    private void replaceBankTabNumbers() {
        Widget bankTabCont = this.client.getWidget(WidgetInfo.BANK_TAB_CONTAINER);
        if (bankTabCont != null) {
            if (bankTabCont.getChild(11).getType() == 5 || bankTabCont.getChild(11).getHeight() == 35) {
                for (int i = 11; i < 20; ++i) {
                    Widget bankTabChildren = bankTabCont.getChild(i);
                    int getChildX = bankTabChildren.getOriginalX();
                    int widgetType = bankTabCont.getChild(19).getType();
                    if (widgetType == 4 && bankTabCont.getChild(19).getHeight() != 35) continue;
                    bankTabChildren.setOpacity(0);
                    bankTabChildren.setOriginalY(0);
                    bankTabChildren.setXTextAlignment(1);
                    bankTabChildren.setYTextAlignment(1);
                    bankTabChildren.setOriginalWidth(41);
                    bankTabChildren.setOriginalHeight(40);
                    bankTabChildren.setOriginalHeight(40);
                    bankTabChildren.setItemId(-1);
                    bankTabChildren.setType(4);
                    bankTabChildren.setTextShadowed(true);
                    this.clientThread.invoke(() -> ((Widget)bankTabChildren).revalidate());
                    if (widgetType == 4) continue;
                    bankTabChildren.setOriginalX(getChildX - 3);
                    this.clientThread.invoke(() -> ((Widget)bankTabChildren).revalidate());
                }
                this.replaceText();
                this.clientThread.invokeLater(() -> ((Widget)bankTabCont).revalidate());
                return;
            }
            this.replaceText();
            this.clientThread.invokeLater(() -> ((Widget)bankTabCont).revalidate());
        }
    }

    private void replaceText() {
        Widget bankTabCont = this.client.getWidget(WidgetInfo.BANK_TAB_CONTAINER);
        if (bankTabCont != null) {
            bankTabCont.getChild(11).setText(this.config.tab1Name());
            bankTabCont.getChild(11).setText(this.config.tab1Name());
            bankTabCont.getChild(12).setText(this.config.tab2Name());
            bankTabCont.getChild(13).setText(this.config.tab3Name());
            bankTabCont.getChild(14).setText(this.config.tab4Name());
            bankTabCont.getChild(15).setText(this.config.tab5Name());
            bankTabCont.getChild(16).setText(this.config.tab6Name());
            bankTabCont.getChild(17).setText(this.config.tab7Name());
            bankTabCont.getChild(18).setText(this.config.tab8Name());
            bankTabCont.getChild(19).setText(this.config.tab9Name());
            bankTabCont.getChild(11).setFontId(this.config.bankFont1().tabFontId);
            bankTabCont.getChild(12).setFontId(this.config.bankFont2().tabFontId);
            bankTabCont.getChild(13).setFontId(this.config.bankFont3().tabFontId);
            bankTabCont.getChild(14).setFontId(this.config.bankFont4().tabFontId);
            bankTabCont.getChild(15).setFontId(this.config.bankFont5().tabFontId);
            bankTabCont.getChild(16).setFontId(this.config.bankFont6().tabFontId);
            bankTabCont.getChild(17).setFontId(this.config.bankFont7().tabFontId);
            bankTabCont.getChild(18).setFontId(this.config.bankFont8().tabFontId);
            bankTabCont.getChild(19).setFontId(this.config.bankFont9().tabFontId);
            bankTabCont.getChild(11).setTextColor(this.config.bankFontColor1().getRGB());
            bankTabCont.getChild(12).setTextColor(this.config.bankFontColor2().getRGB());
            bankTabCont.getChild(13).setTextColor(this.config.bankFontColor3().getRGB());
            bankTabCont.getChild(14).setTextColor(this.config.bankFontColor4().getRGB());
            bankTabCont.getChild(15).setTextColor(this.config.bankFontColor5().getRGB());
            bankTabCont.getChild(16).setTextColor(this.config.bankFontColor6().getRGB());
            bankTabCont.getChild(17).setTextColor(this.config.bankFontColor7().getRGB());
            bankTabCont.getChild(18).setTextColor(this.config.bankFontColor8().getRGB());
            bankTabCont.getChild(19).setTextColor(this.config.bankFontColor9().getRGB());
            if (!this.config.disableMainTabName()) {
                bankTabCont.getChild(10).setType(4);
                bankTabCont.getChild(10).setOpacity(0);
                bankTabCont.getChild(10).setOriginalY(0);
                bankTabCont.getChild(10).setXTextAlignment(1);
                bankTabCont.getChild(10).setYTextAlignment(1);
                bankTabCont.getChild(10).setOriginalWidth(41);
                bankTabCont.getChild(10).setOriginalHeight(40);
                bankTabCont.getChild(10).setText(this.config.tab0Name());
                bankTabCont.getChild(10).setTextColor(this.config.bankFontColor0().getRGB());
                bankTabCont.getChild(10).setFontId(this.config.bankFont0().tabFontId);
                this.clientThread.invoke(() -> ((Widget)bankTabCont.getChild(10)).revalidate());
            }
            if (this.config.disableMainTabName()) {
                bankTabCont.getChild(10).setOpacity(20);
                bankTabCont.getChild(10).setType(5);
                bankTabCont.getChild(10).setOriginalWidth(36);
                bankTabCont.getChild(10).setOriginalHeight(32);
                bankTabCont.getChild(10).setOriginalY(4);
                this.clientThread.invoke(() -> ((Widget)bankTabCont.getChild(10)).revalidate());
            }
        }
    }
}

