/*
 * Decompiled with CFR 0.152.
 */
package com.qolting.UI;

import com.qolting.Blackout.BlackoutQuad;
import com.qolting.Blackout.BlackoutVector;
import com.qolting.QoltingPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.ArrayList;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class QoltingBlackoutOverlay
extends Overlay {
    public int gameWidth;
    public int gameHeight;
    public int padding;
    public Color color;
    public ArrayList<BlackoutQuad> quads = new ArrayList();

    public QoltingBlackoutOverlay(QoltingPlugin plugin, int gameWidth, int gameHeight, int padding, Color color) {
        super((Plugin)plugin);
        this.gameHeight = gameHeight;
        this.gameWidth = gameWidth;
        this.padding = padding;
        this.color = color;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setDragTargetable(false);
        this.setBounds(new Rectangle(0, 0, gameWidth, gameHeight));
        this.setPriority(OverlayPriority.HIGHEST);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public void addQuad(Polygon gon) {
        if (gon == null || gon.xpoints == null) {
            return;
        }
        this.quads.add(new BlackoutQuad(new BlackoutVector(gon.xpoints[0], gon.ypoints[0]), new BlackoutVector(gon.xpoints[1], gon.ypoints[1]), new BlackoutVector(gon.xpoints[2], gon.ypoints[2]), new BlackoutVector(gon.xpoints[3], gon.ypoints[3])));
    }

    public Dimension render(Graphics2D graphics2D) {
        Area clippingArea = new Area(new Rectangle(0, 0, this.gameWidth, this.gameHeight));
        for (BlackoutQuad quad : this.quads) {
            clippingArea.subtract(new Area(BlackoutQuad.expandRectangle(quad.getBounds(), this.padding)));
        }
        graphics2D.setClip(clippingArea);
        graphics2D.setColor(this.color);
        graphics2D.fillRect(0, 0, this.gameWidth, this.gameHeight);
        return new Dimension(this.gameWidth, this.gameHeight);
    }
}

