/*
 * Decompiled with CFR 0.152.
 */
package com.qolting.UI;

import com.qolting.QoltingPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class QoltingAltarOverlay
extends Overlay {
    public int prayer;
    public int maxPrayer;
    public int threshold;
    public Color backgroundColor;
    public Color foregroundColor;
    public Color flashingColor;
    public Color foregroundLowColor;
    public Color foregroundOffColor;
    public boolean displayPrayer;
    public boolean displayOutline;
    private int counter = 0;
    public int gameWidth = 100;
    public int barHeight = 25;
    public int flashInterval = 10;
    private final QoltingPlugin plugin;

    @Inject
    public QoltingAltarOverlay(QoltingPlugin plugin, int prayer, int maxPrayer, int threshold, Color backgroundColor, Color foregroundColor, Color foregroundLowColor, Color foregroundOffColor, Color flashingColor) {
        super((Plugin)plugin);
        this.prayer = prayer;
        this.maxPrayer = maxPrayer;
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.flashingColor = flashingColor;
        this.foregroundLowColor = foregroundLowColor;
        this.foregroundOffColor = foregroundOffColor;
        this.threshold = threshold;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setDragTargetable(false);
        this.setBounds(new Rectangle(0, 0, this.gameWidth, this.barHeight));
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    public Dimension render(Graphics2D graphics) {
        int rightSideDisplayWidth = this.displayPrayer ? 50 : 0;
        ++this.counter;
        graphics.setColor(this.backgroundColor);
        if (this.prayer <= this.threshold && this.counter % this.flashInterval <= this.flashInterval / 2) {
            graphics.setColor(this.flashingColor);
        }
        graphics.fillRect(0, 0, this.gameWidth, this.barHeight);
        graphics.setColor(this.foregroundColor);
        if (this.plugin.isPrayerOff()) {
            graphics.setColor(this.foregroundOffColor);
        } else if (this.prayer <= this.threshold) {
            graphics.setColor(this.foregroundLowColor);
        }
        graphics.fillRect(0, 0, (this.gameWidth - rightSideDisplayWidth) * this.prayer / this.maxPrayer, this.barHeight);
        if (this.displayPrayer) {
            graphics.setColor(this.foregroundColor);
            graphics.fillRect(this.gameWidth - rightSideDisplayWidth + 1, 0, rightSideDisplayWidth - 1, this.barHeight);
            String letsWrite = this.prayer + "/" + this.maxPrayer;
            FontMetrics metrics = graphics.getFontMetrics();
            graphics.setColor(new Color(this.backgroundColor.getRGB()));
            graphics.drawString(letsWrite, this.gameWidth - rightSideDisplayWidth / 2 - metrics.stringWidth(letsWrite) / 2, this.barHeight / 2 + metrics.getAscent() / 2);
        }
        if (this.displayOutline) {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, this.barHeight - 2, this.gameWidth, 2);
        }
        return new Dimension(this.gameWidth, this.barHeight);
    }
}

