/*
 * Decompiled with CFR 0.152.
 */
package com.qolting;

import com.google.inject.Provides;
import com.qolting.AccountManager.QoltingAccountInfo;
import com.qolting.AccountManager.QoltingAccountManager;
import com.qolting.AccountManager.QoltingAccountManagerFrame;
import com.qolting.Blackout.BlackoutQuad;
import com.qolting.GroundItem;
import com.qolting.LootItem;
import com.qolting.QoltingConfig;
import com.qolting.UI.QoltingAltarOverlay;
import com.qolting.UI.QoltingBlackoutOverlay;
import com.qolting.UI.QoltingNearbyPanel;
import com.qolting.UI.QoltingProfitPanel;
import com.qolting.UI.QoltingRSNOverlay;
import com.qolting.UI.QoltingShoutOverlay;
import com.qolting.UI.QoltingSlotsLeftOverlay;
import java.awt.Polygon;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.api.TileItem;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemQuantityChanged;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.kit.KitType;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Qolting")
public class QoltingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(QoltingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private QoltingConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    private QoltingAccountManager qoltingAccountManager;
    private QoltingAccountManagerFrame currentManager = null;
    private File qoltingDirectory = new File(RuneLite.RUNELITE_DIR, "qolting");
    public ArrayList<GroundItem> nearbyItems = new ArrayList();
    private QoltingAltarOverlay qoltingAltarPanel = null;
    private QoltingRSNOverlay qoltingRSNOverlay = null;
    private QoltingProfitPanel qoltingProfitPanel = null;
    private QoltingShoutOverlay qoltingShoutPanel = null;
    private QoltingNearbyPanel qoltingNearbyPanel = null;
    private QoltingSlotsLeftOverlay qoltingSlotsLeftOverlay = null;
    private QoltingBlackoutOverlay qoltingBlackoutOverlay = null;
    private Item[] lastPlayerInventory = null;
    private static final long CLIP_MTIME_UNLOADED = -2L;
    private static final long CLIP_MTIME_BUILTIN = -1L;
    public static final String LOCK_FILE = "qoltingDisableBLACKOUT.txt";
    public int GPhr = 0;
    public final File[] files = new File[]{new File(RuneLite.RUNELITE_DIR, "qolting\\yoink.wav"), new File(RuneLite.RUNELITE_DIR, "qolting\\shard.wav"), new File(RuneLite.RUNELITE_DIR, "qolting\\onyx.wav"), new File(RuneLite.RUNELITE_DIR, "qolting\\prayer.wav"), new File(RuneLite.RUNELITE_DIR, "qolting\\health.wav"), new File(RuneLite.RUNELITE_DIR, "qolting\\regularDrop.wav")};
    public final Clip[] clips = new Clip[]{null, null, null, null, null, null};
    private long[] lastClipMTime = new long[]{-2L, -2L, -2L, -2L, -2L, -2L};
    private final byte YOINK = 0;
    private final byte SHARD = 1;
    private final byte ONYX = (byte)2;
    private final byte PRAYER = (byte)3;
    private final byte HEALTH = (byte)4;
    private final byte REGULAR_DROP = (byte)5;
    int takingItem = 0;
    int ownLootTimer = 0;
    boolean playShardSoundNextTick = false;
    float timeElapsed = 0.0f;
    int previousPrayer = 0;
    int previousHealth = 0;

    private void updateAltar() {
        if (!this.config.altarBar()) {
            this.overlayManager.remove((Overlay)this.qoltingAltarPanel);
            return;
        }
        this.overlayManager.add((Overlay)this.qoltingAltarPanel);
        this.qoltingAltarPanel.maxPrayer = this.client.getRealSkillLevel(Skill.PRAYER);
        this.qoltingAltarPanel.prayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
        this.qoltingAltarPanel.gameWidth = this.client.getViewportWidth();
    }

    private void updateRSN() {
        if (!this.config.rsnDisplay()) {
            this.overlayManager.remove((Overlay)this.qoltingRSNOverlay);
            return;
        }
        this.overlayManager.add((Overlay)this.qoltingRSNOverlay);
    }

    private void updateProfit() {
        this.timeElapsed += 0.6f;
        this.GPhr = Math.round((float)this.qoltingProfitPanel.profit / this.timeElapsed * 60.0f * 60.0f) / 1000;
        if (!this.config.sessionTracker()) {
            this.overlayManager.remove((Overlay)this.qoltingProfitPanel);
            return;
        }
        this.overlayManager.add((Overlay)this.qoltingProfitPanel);
    }

    private void updateShout() {
        boolean[] thingsToBeFussedAbout = new boolean[]{false, false, false};
        boolean any = false;
        if (this.config.tooAFKIndicator() && this.tooAFK()) {
            thingsToBeFussedAbout[0] = true;
            any = true;
        }
        if (this.config.treasureNear() && this.shardNear()) {
            thingsToBeFussedAbout[1] = true;
            any = true;
        }
        if (this.config.goBank() && this.inventoryFull()) {
            thingsToBeFussedAbout[2] = true;
            any = true;
        }
        this.qoltingShoutPanel.thingsToBeFussedAbout = thingsToBeFussedAbout;
        this.qoltingShoutPanel.viewportWidth = this.client.getViewportWidth();
        this.qoltingShoutPanel.viewportHeight = this.client.getViewportHeight();
        if (any) {
            this.overlayManager.add((Overlay)this.qoltingShoutPanel);
        } else {
            this.overlayManager.remove((Overlay)this.qoltingShoutPanel);
        }
    }

    private void updateNearby() {
        if (!this.config.doNearbyDrops()) {
            this.overlayManager.remove((Overlay)this.qoltingNearbyPanel);
            return;
        }
        this.overlayManager.add((Overlay)this.qoltingNearbyPanel);
    }

    private void updateSlotsLeft() {
        if (!this.config.slotsLeft()) {
            this.overlayManager.remove((Overlay)this.qoltingSlotsLeftOverlay);
            return;
        }
        this.overlayManager.add((Overlay)this.qoltingSlotsLeftOverlay);
        this.qoltingSlotsLeftOverlay.slotsLeft = this.getSlotsLeft();
    }

    private void updateBlackout() {
        if (!this.config.blackoutOverlay() || new File(RuneLite.RUNELITE_DIR, LOCK_FILE).exists()) {
            this.overlayManager.remove((Overlay)this.qoltingBlackoutOverlay);
            return;
        }
        this.overlayManager.add((Overlay)this.qoltingBlackoutOverlay);
        this.qoltingBlackoutOverlay.gameHeight = this.client.getViewportHeight();
        this.qoltingBlackoutOverlay.gameWidth = this.client.getViewportWidth();
        this.qoltingBlackoutOverlay.quads.clear();
        Polygon altarDoor = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)LocalPoint.fromWorld((Client)this.client, (int)3605, (int)3358));
        Polygon bankDoor = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)LocalPoint.fromWorld((Client)this.client, (int)3605, (int)3365));
        if (this.client.getLocalPlayer().getWorldLocation().isInArea2D(new WorldArea[]{new WorldArea(3601, 3365, 8, 5, 0)}) || this.client.getLocalPlayer().getWorldLocation().isInArea2D(new WorldArea[]{new WorldArea(3601, 3353, 8, 6, 0)}) || this.isPrayerOff() || this.tooAFK()) {
            this.qoltingBlackoutOverlay.quads.add(new BlackoutQuad(0, 0, this.client.getViewportWidth(), this.client.getViewportHeight()));
            return;
        }
        for (GroundItem item : this.nearbyItems) {
            LocalPoint location;
            if (item.quantity * this.itemManager.getItemPrice(item.id) < this.config.nearbyThreshold() || this.ignoreItem(item.id) || (location = LocalPoint.fromWorld((Client)this.client, (WorldPoint)item.worldPoint)) == null) continue;
            Polygon gon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)location);
            this.qoltingBlackoutOverlay.addQuad(gon);
        }
        if (this.client.getBoostedSkillLevel(Skill.PRAYER) <= this.config.altarThreshold() || this.config.blackoutGlobalDisplayAltar() && this.isAnyAccountLowPrayer()) {
            Polygon altar = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)LocalPoint.fromWorld((Client)this.client, (int)3605, (int)3354), (int)3, (int)3, (int)this.client.getPlane(), (int)this.client.getLocalPlayer().getWorldArea().getHeight());
            this.qoltingBlackoutOverlay.addQuad(altar);
        }
        if ((this.client.getBoostedSkillLevel(Skill.PRAYER) <= this.config.altarThreshold() || this.client.getLocalPlayer().getWorldLocation().isInArea2D(new WorldArea[]{new WorldArea(3601, 3353, 8, 6, 0)}) || this.config.blackoutGlobalDisplayAltar() && this.isAnyAccountLowPrayer()) && this.isDoorClosed(3605, 3358)) {
            this.qoltingBlackoutOverlay.addQuad(altarDoor);
        }
        if (this.getSlotsLeft() <= 2) {
            Polygon bank = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)LocalPoint.fromWorld((Client)this.client, (int)3607, (int)3368));
            this.qoltingBlackoutOverlay.addQuad(bank);
        }
        if ((this.getSlotsLeft() <= 2 || this.client.getLocalPlayer().getWorldLocation().isInArea2D(new WorldArea[]{new WorldArea(3601, 3365, 8, 5, 0)})) && this.isDoorClosed(3605, 3365)) {
            this.qoltingBlackoutOverlay.addQuad(bankDoor);
        }
    }

    public boolean isDoorClosed(int worldX, int worldY) {
        LocalPoint coords = LocalPoint.fromWorld((Client)this.client, (int)worldX, (int)worldY);
        return this.client.getScene().getTiles()[0][coords.getSceneX()][coords.getSceneY()].getWallObject() != null;
    }

    public String getItemName(int id) {
        return this.client.getItemDefinition(id).getName();
    }

    public int getItemPrice(int id) {
        return this.itemManager.getItemPrice(id);
    }

    public boolean inventoryFull() {
        ItemContainer invent = this.client.getItemContainer(InventoryID.INVENTORY);
        if (invent == null) {
            return false;
        }
        if (invent.getItems().length < 28) {
            return false;
        }
        boolean full = true;
        for (Item i : invent.getItems()) {
            if (i == null) {
                full = false;
                break;
            }
            if (i.getQuantity() != 0) continue;
            full = false;
        }
        return full;
    }

    public int getSlotsLeft() {
        ItemContainer invent = this.client.getItemContainer(InventoryID.INVENTORY);
        if (invent == null) {
            return 28;
        }
        int itemsCounted = 0;
        for (Item i : invent.getItems()) {
            if (i == null || i.getQuantity() == 0) continue;
            ++itemsCounted;
        }
        return 28 - itemsCounted;
    }

    public boolean shardNear() {
        for (GroundItem i : this.nearbyItems) {
            if (i.id != 24777) continue;
            return true;
        }
        return false;
    }

    public boolean tooAFK() {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return false;
        }
        if (localPlayer.getPlayerComposition().getEquipmentId(KitType.TORSO) == 24676 || localPlayer.getPlayerComposition().getEquipmentId(KitType.LEGS) == 24678 || localPlayer.getPlayerComposition().getEquipmentId(KitType.BOOTS) == 24680) {
            return true;
        }
        return this.client.getVarpValue(172) == 1;
    }

    public boolean isPrayerOff() {
        for (Prayer pray : Prayer.values()) {
            if (!this.client.isPrayerActive(pray)) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyAccountLowPrayer() {
        if (this.client.getBoostedSkillLevel(Skill.PRAYER) <= this.config.altarThreshold()) {
            return true;
        }
        ArrayList<QoltingAccountInfo> info = this.qoltingAccountManager.getAllAccountInfo();
        for (QoltingAccountInfo i : info) {
            if (i.prayer > this.config.altarThreshold()) continue;
            return true;
        }
        return false;
    }

    private boolean isPlayerInGoodRegionToEnablePlugin() {
        boolean result = false;
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer != null) {
            result = this.config.onlyInDarkmeyer() ? localPlayer.getWorldLocation().getRegionID() == 14388 || localPlayer.getWorldLocation().getRegionID() == 14387 : true;
        }
        return result;
    }

    public boolean ignoreItem(int id) {
        String name = this.getItemName(id);
        return this.ignoreItem(name);
    }

    public boolean ignoreItem(String name) {
        for (String s : this.config.nearbyBlacklist().split(",")) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public String getRSN() {
        if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
            return "?";
        }
        return this.client.getLocalPlayer().getName();
    }

    private void removeAllPanels() {
        this.overlayManager.remove((Overlay)this.qoltingAltarPanel);
        this.overlayManager.remove((Overlay)this.qoltingRSNOverlay);
        this.overlayManager.remove((Overlay)this.qoltingProfitPanel);
        this.overlayManager.remove((Overlay)this.qoltingShoutPanel);
        this.overlayManager.remove((Overlay)this.qoltingNearbyPanel);
        this.overlayManager.remove((Overlay)this.qoltingSlotsLeftOverlay);
        this.overlayManager.remove((Overlay)this.qoltingBlackoutOverlay);
    }

    protected void startUp() {
        this.qoltingAccountManager = new QoltingAccountManager(this.qoltingDirectory);
        this.qoltingAltarPanel = new QoltingAltarOverlay(this, 0, 0, this.config.altarThreshold(), this.config.altarBackground(), this.config.altarForeground(), this.config.altarForegroundLow(), this.config.altarForegroundOff(), this.config.altarFlashing());
        this.qoltingRSNOverlay = new QoltingRSNOverlay(this);
        this.qoltingProfitPanel = new QoltingProfitPanel(this);
        this.qoltingShoutPanel = new QoltingShoutOverlay(this, this.client.getViewportWidth(), this.client.getViewportHeight());
        this.qoltingNearbyPanel = new QoltingNearbyPanel(this);
        this.qoltingSlotsLeftOverlay = new QoltingSlotsLeftOverlay(this);
        this.qoltingBlackoutOverlay = new QoltingBlackoutOverlay(this, this.client.getViewportWidth(), this.client.getViewportHeight(), this.config.blackoutPadding(), this.config.blackoutColor());
        this.updateConfig();
    }

    protected void shutDown() {
        this.removeAllPanels();
    }

    private synchronized void playCustomSound(byte index, boolean justOnce) {
        long currentMTime;
        File file = this.files[index];
        long l = currentMTime = file.exists() ? file.lastModified() : -1L;
        if (this.clips[index] == null || currentMTime != this.lastClipMTime[index] || !this.clips[index].isOpen()) {
            if (this.clips[index] != null) {
                this.clips[index].close();
            }
            try {
                this.clips[index] = AudioSystem.getClip();
            }
            catch (LineUnavailableException e) {
                this.lastClipMTime[index] = -2L;
                log.warn("Unable to play notification", (Throwable)e);
                return;
            }
            this.lastClipMTime[index] = currentMTime;
            if (!this.tryLoadNotification(index)) {
                return;
            }
        }
        this.clips[index].setMicrosecondPosition(0L);
        this.clips[index].loop(justOnce ? 0 : Math.min(Math.max(0, this.config.loopBlasters() - 1), 100));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean tryLoadNotification(byte index) {
        File file = this.files[index];
        if (file.exists()) {
            try (BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(file));){
                boolean bl;
                block14: {
                    AudioInputStream sound = AudioSystem.getAudioInputStream(fileStream);
                    try {
                        this.clips[index].open(sound);
                        bl = true;
                        if (sound == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (sound != null) {
                            try {
                                sound.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    sound.close();
                }
                return bl;
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                log.warn("Unable to load notification sound", (Throwable)e);
            }
        }
        return false;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked clicked) {
        if (clicked.getMenuOption().toLowerCase().contains("take")) {
            this.takingItem = 10;
        }
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getEntry().getMenuAction() == MenuAction.RUNELITE_OVERLAY && event.getEntry().getTarget().equals("List") && event.getEntry().getOption().equals("Clear")) {
            this.nearbyItems.clear();
        }
        if (event.getEntry().getMenuAction() == MenuAction.RUNELITE_OVERLAY && event.getEntry().getTarget().equals("Profit") && event.getEntry().getOption().equals("Clear")) {
            this.qoltingProfitPanel.profit = 0;
        }
    }

    private Item[] getInventoryList(ItemContainerChanged changed) {
        return (Item[])ArrayUtils.addAll((Object[])changed.getItemContainer().getItems(), (Object[])this.client.getItemContainer(InventoryID.EQUIPMENT).getItems());
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged containerChanged) {
        if (containerChanged.getContainerId() == InventoryID.INVENTORY.getId()) {
            if (this.takingItem == 0) {
                this.lastPlayerInventory = this.getInventoryList(containerChanged);
                return;
            }
            if (this.lastPlayerInventory == null) {
                this.lastPlayerInventory = this.getInventoryList(containerChanged);
                return;
            }
            block0: for (int count = 0; count < containerChanged.getItemContainer().getItems().length; ++count) {
                Item i = containerChanged.getItemContainer().getItems()[count];
                if (i == null) continue;
                for (int count2 = 0; count2 < count; ++count2) {
                    if (containerChanged.getItemContainer().getItems()[count2].getId() == containerChanged.getItemContainer().getItems()[count].getId()) continue block0;
                }
                int lastAmount = 0;
                int newAmount = 0;
                for (Item j : this.lastPlayerInventory) {
                    if (j.getId() != i.getId()) continue;
                    lastAmount += j.getQuantity();
                }
                for (Item j : containerChanged.getItemContainer().getItems()) {
                    if (j.getId() != i.getId()) continue;
                    newAmount += j.getQuantity();
                }
                if (newAmount - lastAmount <= 0) continue;
                this.qoltingProfitPanel.profit += this.itemManager.getItemPrice(i.getId()) * (newAmount - lastAmount);
            }
            this.lastPlayerInventory = this.getInventoryList(containerChanged);
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        for (ItemStack i : npcLootReceived.getItems()) {
            if (i.getId() != 24777) continue;
            this.ownLootTimer = 10;
            break;
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        if (item.getId() == 24777 && this.config.customBlushard()) {
            this.playShardSoundNextTick = true;
        } else if (item.getId() == 9194 && this.config.customOnItsBoltTips()) {
            this.playCustomSound((byte)2, this.config.loopUntil());
        } else if (this.config.customRegularDrops() && this.getItemPrice(item.getId()) * item.getQuantity() >= this.config.nearbyThreshold()) {
            this.playCustomSound((byte)5, false);
        }
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        if (Math.abs(itemSpawned.getTile().getWorldLocation().getX() - this.client.getLocalPlayer().getWorldLocation().getX()) > this.config.nearbyRange() || Math.abs(itemSpawned.getTile().getWorldLocation().getY() - this.client.getLocalPlayer().getWorldLocation().getY()) > this.config.nearbyRange()) {
            return;
        }
        boolean existing = false;
        this.nearbyItems.add(new GroundItem(item.getId(), item.getQuantity(), itemSpawned.getTile().getWorldLocation(), this.client.getGameCycle()));
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        TileItem item = itemDespawned.getItem();
        for (GroundItem i : this.nearbyItems) {
            if (i.id != item.getId() || i.quantity != itemDespawned.getItem().getQuantity()) continue;
            this.nearbyItems.remove(i);
            break;
        }
    }

    @Subscribe
    public void onBeforeRender(BeforeRender render) {
        if (this.config.blackoutFPS() && this.isPlayerInGoodRegionToEnablePlugin()) {
            this.updateBlackout();
        }
    }

    @Subscribe
    public void onItemQuantityChanged(ItemQuantityChanged itemQuantityChanged) {
        TileItem item = itemQuantityChanged.getItem();
        for (GroundItem i : this.nearbyItems) {
            if (i.id != item.getId() || itemQuantityChanged.getOldQuantity() != i.quantity) continue;
            i.quantity = itemQuantityChanged.getNewQuantity();
            break;
        }
    }

    public void updateConfig() {
        this.qoltingAltarPanel.backgroundColor = this.config.altarBackground();
        this.qoltingAltarPanel.foregroundColor = this.config.altarForeground();
        this.qoltingAltarPanel.flashingColor = this.config.altarFlashing();
        this.qoltingAltarPanel.foregroundLowColor = this.config.altarForegroundLow();
        this.qoltingAltarPanel.foregroundOffColor = this.config.altarForegroundOff();
        this.qoltingAltarPanel.threshold = this.config.altarThreshold();
        this.qoltingAltarPanel.barHeight = this.config.altarSize();
        this.qoltingAltarPanel.displayOutline = this.config.altarOutline();
        this.qoltingAltarPanel.displayPrayer = this.config.altarPrayer();
        this.qoltingAltarPanel.flashInterval = this.config.flashyInterval();
        this.qoltingRSNOverlay.fontSize = this.config.rsnFontSize();
        this.qoltingSlotsLeftOverlay.fontSize = this.config.slotsLeftFontSize();
        this.qoltingNearbyPanel.threshold = this.config.nearbyThreshold();
        this.qoltingShoutPanel.flashInterval = this.config.flashyInterval();
        this.qoltingBlackoutOverlay.color = this.config.blackoutColor();
        this.qoltingBlackoutOverlay.padding = this.config.blackoutPadding();
        if (this.currentManager != null) {
            this.currentManager.frame.setAlwaysOnTop(this.config.alwaysOnTopTracker());
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        this.updateConfig();
        if (configChanged.getKey().equals("launchAccountTracker")) {
            if (this.currentManager != null) {
                this.currentManager.close();
            }
            this.currentManager = new QoltingAccountManagerFrame(this.qoltingAccountManager, this.config.alwaysOnTopTracker(), this);
            this.currentManager.update(this.config.altarThreshold(), this.config.nearbyThreshold());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        int state = gameStateChanged.getGameState().getState();
        if (state == GameState.HOPPING.getState() || state == GameState.LOGGING_IN.getState() || state == GameState.STARTING.getState()) {
            this.nearbyItems.clear();
        }
    }

    public void updateStatusNoise() {
        if (this.config.customPrayer() && this.previousPrayer > this.config.altarThreshold() && this.client.getBoostedSkillLevel(Skill.PRAYER) <= this.config.altarThreshold()) {
            this.playCustomSound((byte)3, false);
        }
        if (this.config.customLowHP() && this.previousHealth > 50 && this.client.getBoostedSkillLevel(Skill.HITPOINTS) <= 49) {
            this.playCustomSound((byte)4, false);
        }
        this.previousPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
        this.previousHealth = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.config.useAccountTracker()) {
            ArrayList<LootItem> items = new ArrayList<LootItem>();
            for (GroundItem item : this.nearbyItems) {
                items.add(new LootItem(item, this));
            }
            this.qoltingAccountManager.saveAccountInfo(this.getRSN(), this.client.getBoostedSkillLevel(Skill.PRAYER), this.client.getBoostedSkillLevel(Skill.HITPOINTS), this.getSlotsLeft(), items, this.client.getLocalPlayer().getWorldLocation(), this.qoltingProfitPanel.profit, this.GPhr);
        }
        if (this.currentManager != null) {
            this.currentManager.update(this.config.altarThreshold(), this.config.nearbyThreshold());
        }
        if (!this.isPlayerInGoodRegionToEnablePlugin()) {
            this.removeAllPanels();
            return;
        }
        if (this.config.loopUntil()) {
            for (GroundItem item : this.nearbyItems) {
                if (!(item.id != 24777 || this.clips[1] != null && this.clips[1].isRunning())) {
                    this.playCustomSound((byte)1, true);
                } else {
                    if (item.id != 9194 || this.clips[2] != null && this.clips[2].isRunning()) continue;
                    this.playCustomSound((byte)2, true);
                }
                break;
            }
        } else if (this.playShardSoundNextTick) {
            if (this.ownLootTimer == 0 && this.config.customYoink()) {
                this.playCustomSound((byte)0, false);
            } else if (this.config.customBlushard()) {
                this.playCustomSound((byte)1, false);
            }
            this.playShardSoundNextTick = false;
        }
        for (GroundItem i : this.nearbyItems) {
            boolean overflow;
            int gameCycle = this.client.getGameCycle();
            boolean bl = overflow = gameCycle - i.addedAtGameCycle < 0;
            if (gameCycle - i.addedAtGameCycle < GroundItem.GAME_CYCLES_BEFORE_REMOVAL && !overflow) continue;
            this.nearbyItems.remove(i);
        }
        this.updateStatusNoise();
        this.updateAltar();
        this.updateRSN();
        this.updateProfit();
        this.updateShout();
        this.updateNearby();
        this.updateSlotsLeft();
        this.updateBlackout();
        this.takingItem = Math.max(0, this.takingItem - 1);
        this.ownLootTimer = Math.max(0, this.ownLootTimer - 1);
    }

    @Provides
    QoltingConfig provideConfig(ConfigManager configManager) {
        return (QoltingConfig)configManager.getConfig(QoltingConfig.class);
    }
}

