/*
 * Decompiled with CFR 0.152.
 */
package com.qolting.AccountManager;

import com.qolting.AccountManager.QoltingAccountInfo;
import com.qolting.AccountManager.QoltingAccountManager;
import com.qolting.LootItem;
import com.qolting.QoltingPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import net.runelite.client.RuneLite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QoltingAccountManagerFrame {
    private static final Logger log = LoggerFactory.getLogger(QoltingAccountManagerFrame.class);
    public JFrame frame;
    private volatile boolean running = true;
    public JTextPane lowPrayer;
    public JTextPane lootNearby;
    public JTextPane lowBackpack;
    public JTextPane atAltarBank;
    public JButton toggleBlackout;
    public JTextPane GPhr;
    public JTextPane totalProfit;
    public JPanel pageEnd;
    public QoltingPlugin plugin;
    public volatile QoltingAccountManager manager;

    public QoltingAccountManagerFrame(QoltingAccountManager manager, boolean alwaysOnTop, QoltingPlugin plugin) {
        this.manager = manager;
        this.createWindow();
        this.frame.setAlwaysOnTop(alwaysOnTop);
        this.plugin = plugin;
    }

    public void close() {
        this.frame.dispose();
    }

    public void createWindow() {
        this.frame = new JFrame("Qolting Account Manager");
        this.frame.setSize(500, 300);
        this.frame.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(1, 4));
        this.lowPrayer = new JTextPane();
        this.lootNearby = new JTextPane();
        this.lowBackpack = new JTextPane();
        this.atAltarBank = new JTextPane();
        this.lowPrayer.setEditable(false);
        this.lootNearby.setEditable(false);
        this.lowBackpack.setEditable(false);
        this.atAltarBank.setEditable(false);
        this.lowPrayer.setContentType("text/html");
        this.lowBackpack.setContentType("text/html");
        this.lootNearby.setContentType("text/html");
        this.atAltarBank.setContentType("text/html");
        this.toggleBlackout = new JButton("Force Disable Blackout");
        File lock = new File(RuneLite.RUNELITE_DIR, "qoltingDisableBLACKOUT.txt");
        if (lock.exists()) {
            lock.delete();
        }
        this.toggleBlackout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = new File(RuneLite.RUNELITE_DIR, "qoltingDisableBLACKOUT.txt");
                if (file.exists()) {
                    file.delete();
                    QoltingAccountManagerFrame.this.toggleBlackout.setText("Force Disable Blackout");
                } else {
                    try {
                        file.createNewFile();
                        QoltingAccountManagerFrame.this.toggleBlackout.setText("Un-force-disable Blackout");
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        QoltingAccountManagerFrame.this.toggleBlackout.setText("Could not disable blackout (try again)");
                    }
                }
            }
        });
        panel.add(this.lowPrayer);
        panel.add(this.lootNearby);
        panel.add(this.lowBackpack);
        panel.add(this.atAltarBank);
        this.GPhr = new JTextPane();
        this.GPhr.setContentType("text/html");
        this.GPhr.setEditable(false);
        this.totalProfit = new JTextPane();
        this.totalProfit.setContentType("text/html");
        this.totalProfit.setEditable(false);
        this.pageEnd = new JPanel(new GridLayout(1, 2));
        this.pageEnd.setBackground(new Color(5, 5, 5));
        this.frame.add((Component)this.pageEnd, "Last");
        this.pageEnd.add(this.GPhr);
        this.pageEnd.add(this.totalProfit);
        this.frame.add((Component)this.toggleBlackout, "First");
        this.frame.add((Component)panel, "Center");
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                File file = new File(RuneLite.RUNELITE_DIR, "qoltingDisableBLACKOUT.txt");
                if (file.exists()) {
                    file.delete();
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.frame.setVisible(true);
    }

    public void update(int prayerThreshold, int nearbyThreshold) {
        if (!this.frame.isVisible()) {
            return;
        }
        ArrayList<QoltingAccountInfo> data = this.manager.getAllAccountInfo();
        Object lowPrayerT = "<HTML>";
        Object lowBackpackT = "<HTML>";
        Object lootNearbyT = "<HTML>";
        Object atAltarBankT = "<HTML>";
        lowPrayerT = (String)lowPrayerT + this.getSpan("Low Prayer: <br/>", Color.LIGHT_GRAY);
        lowBackpackT = (String)lowBackpackT + this.getSpan("Low Backpack: <br/>", Color.LIGHT_GRAY);
        lootNearbyT = (String)lootNearbyT + this.getSpan("Loot Nearby: <br/>", Color.LIGHT_GRAY);
        atAltarBankT = (String)atAltarBankT + this.getSpan("Stuck Altar/Bank: <br/>", Color.LIGHT_GRAY);
        int totalGPhr = 0;
        int totalledProfit = 0;
        for (QoltingAccountInfo info : data) {
            totalGPhr += info.GPhr;
            totalledProfit += info.profit;
            if (info.prayer <= prayerThreshold) {
                lowPrayerT = (String)lowPrayerT + this.getSpan(info.username + " (" + info.prayer + ")", Color.CYAN);
            }
            if (info.backpackSpaces <= 2) {
                lowBackpackT = (String)lowBackpackT + this.getSpan(info.username + " (" + info.backpackSpaces + ")", new Color(40, 20, 0));
            }
            if (info.items.size() > 0) {
                for (LootItem item : info.items) {
                    int value = item.value * item.quantity;
                    if (value < nearbyThreshold || this.plugin.ignoreItem(item.name)) continue;
                    lootNearbyT = (String)lootNearbyT + this.getSpan(value / 1000 + "k: " + item.name.substring(0, 1).toUpperCase() + item.name.substring(1).toLowerCase() + " * " + item.quantity + " (" + info.username + ")", this.interpolateColors(Color.LIGHT_GRAY, Color.GREEN, Math.max(0.0f, Math.min(1.0f, (float)value / 40000.0f))));
                }
            }
            if (!info.atAltarOrBank) continue;
            atAltarBankT = (String)atAltarBankT + this.getSpan(info.username, new Color(100, 0, 0));
        }
        this.GPhr.setText("<html>" + this.getSpan(totalGPhr + "k GP/hr (" + totalGPhr / data.size() + "k per account)", totalGPhr > 10000 ? new Color(192, 220, 192) : Color.lightGray));
        this.totalProfit.setText("<html><style>body { text-align:right; } </style><body>" + this.getSpan("+" + (totalledProfit /= 1000) + "k GP (" + totalledProfit / data.size() + "k per account)</body>", totalledProfit > 10000 ? new Color(192, 220, 192) : Color.lightGray));
        this.lowPrayer.setText((String)lowPrayerT);
        this.lowBackpack.setText((String)lowBackpackT);
        this.lootNearby.setText((String)lootNearbyT);
        this.atAltarBank.setText((String)atAltarBankT);
    }

    private int lerp(int x, int y, float a) {
        return (int)Math.floor((float)x + (float)(y - x) * a);
    }

    private Color interpolateColors(Color c1, Color c2, float amt) {
        return new Color(this.lerp(c1.getRed(), c2.getRed(), amt), this.lerp(c1.getGreen(), c2.getGreen(), amt), this.lerp(c1.getBlue(), c2.getBlue(), amt));
    }

    private String getSpan(String s, Color c) {
        String hex = "#" + Integer.toHexString(c.getRGB()).substring(2);
        return " <span style=\"color: rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")\">" + s + "</span><br/>";
    }
}

