/*
 * Decompiled with CFR 0.152.
 */
package com.qolting.AccountManager;

import com.qolting.AccountManager.QoltingAccountInfo;
import com.qolting.LootItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QoltingAccountManager {
    private static final Logger log = LoggerFactory.getLogger(QoltingAccountManager.class);
    private final File directory;
    private final int tooOldAge = 5000;

    public QoltingAccountManager(File qoltingDirectory) {
        this.directory = qoltingDirectory;
        this.verifyQoltingDirectory();
    }

    public ArrayList<QoltingAccountInfo> getAllAccountInfo() {
        this.verifyQoltingDirectory();
        ArrayList<QoltingAccountInfo> out = new ArrayList<QoltingAccountInfo>();
        if (this.directory.listFiles() == null) {
            return out;
        }
        for (File f : this.directory.listFiles()) {
            if (Instant.now().toEpochMilli() - f.lastModified() >= 5000L) continue;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(f));
                out.add(new QoltingAccountInfo(reader.readLine()));
                reader.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return out;
    }

    public boolean saveAccountInfo(String name, int prayer, int health, int backpackSpace, ArrayList<LootItem> groundItems, WorldPoint playerPosition, int profit, int GPhr) {
        this.verifyQoltingDirectory();
        QoltingAccountInfo info = new QoltingAccountInfo(name, health, prayer, backpackSpace, groundItems, playerPosition, profit, GPhr);
        File file = new File(this.directory, name + ".txt");
        try {
            file.createNewFile();
            FileWriter writer = new FileWriter(file);
            writer.write(info.toString());
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean verifyQoltingDirectory() {
        return !this.directory.mkdir();
    }
}

