/*
 * Decompiled with CFR 0.152.
 */
package com.qolting.AccountManager;

import com.qolting.LootItem;
import java.util.ArrayList;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;

public class QoltingAccountInfo {
    public String username;
    public int health;
    public int prayer;
    public int backpackSpaces;
    public ArrayList<LootItem> items;
    public boolean atAltarOrBank;
    public int GPhr;
    public int profit;
    public final int itemsStartAt = 5;
    public final WorldArea[] altarOrBank = new WorldArea[]{new WorldArea(3601, 3353, 8, 6, 0), new WorldArea(3601, 3365, 8, 5, 0)};

    public QoltingAccountInfo(String username, int health, int prayer, int backpackSpaces, ArrayList<LootItem> items, WorldPoint area, int profit, int GPhr) {
        this.username = username;
        this.health = health;
        this.prayer = prayer;
        this.backpackSpaces = backpackSpaces;
        this.items = items;
        this.profit = profit;
        this.GPhr = GPhr;
        this.atAltarOrBank = area.isInArea2D(new WorldArea[]{this.altarOrBank[0]}) || area.isInArea2D(new WorldArea[]{this.altarOrBank[1]});
    }

    private boolean collision(int x, int y, int w, int h, int x2, int y2) {
        return x + w >= x2 && y + h >= y2 && x2 >= x && y2 >= y;
    }

    public QoltingAccountInfo(String dataFromString) {
        this.fromString(dataFromString);
    }

    public String toString() {
        Object allToString = "";
        String separator = "";
        for (LootItem i : this.items) {
            allToString = (String)allToString + separator + i.toString();
            separator = ",";
        }
        return this.username + "," + this.health + "," + this.prayer + "," + this.backpackSpaces + "," + this.atAltarOrBank + "," + this.profit + "," + this.GPhr + "," + (String)allToString;
    }

    public void fromString(String string) {
        String[] split = string.split(",");
        this.username = split[0];
        this.health = Integer.parseInt(split[1]);
        this.prayer = Integer.parseInt(split[2]);
        this.backpackSpaces = Integer.parseInt(split[3]);
        this.atAltarOrBank = Boolean.parseBoolean(split[4]);
        this.profit = Integer.parseInt(split[5]);
        this.GPhr = Integer.parseInt(split[6]);
        this.items = new ArrayList();
        for (int i = 7; i < split.length; ++i) {
            this.items.add(new LootItem(split[i]));
        }
    }
}

