/*
 * Decompiled with CFR 0.152.
 */
package com.dice;

import com.dice.Dice;
import com.dice.DiceConfig;
import com.dice.DiceOverlay;
import com.dice.DiceType;
import com.google.inject.Provides;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dice")
public class DicePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DicePlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private DiceConfig config;
    @Inject
    private DiceOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    public boolean ROLL_DICE = false;
    private Widget button = null;
    private Widget parent = null;

    protected void startUp() throws Exception {
        log.info("Dice started!");
        this.overlayManager.add((Overlay)this.overlay);
        this.clientThread.invokeLater(this::createButton);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientThread.invoke(this::hideButton);
        log.info("Dice stopped!");
    }

    @Provides
    DiceConfig provideConfig(ConfigManager configManager) {
        return (DiceConfig)configManager.getConfig(DiceConfig.class);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() != 387) {
            return;
        }
        this.createButton();
    }

    protected void trigger() {
        boolean bl = this.ROLL_DICE = !this.ROLL_DICE;
        if (this.ROLL_DICE) {
            this.button.setSpriteId(698);
            this.button.setAction(0, "Put away dice");
        } else {
            this.button.setSpriteId(573);
            this.button.setAction(0, "Roll dice");
        }
    }

    protected void sayTotal(List<Dice> dices) {
        int total = 0;
        Object message = "";
        int i = 0;
        boolean containsNonNumeric = false;
        dices.sort(Comparator.comparing(Dice::getX));
        for (Dice dice : dices) {
            total += dice.result;
            if (dice.diceType == DiceType.BASIC || dice.diceType == DiceType.MAGIC) {
                message = (String)message + dice.result;
            } else {
                containsNonNumeric = true;
                message = (String)message + dice.specialOutcomes.get(dice.result - 1).getName();
            }
            if (i < dices.size() - 1) {
                message = (String)message + " + ";
            }
            ++i;
        }
        if (containsNonNumeric) {
            total = 0;
        }
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You rolled " + (Serializable)(total > 0 ? Integer.valueOf(total) : "") + " (" + (String)message + ")", null);
    }

    private void hideButton() {
        if (this.button == null) {
            return;
        }
        this.button.setHidden(true);
        try {
            this.parent.getChildren()[this.button.getIndex()] = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.button = null;
    }

    private void createButton() {
        this.parent = this.client.getWidget(WidgetInfo.EQUIPMENT);
        if (this.parent == null) {
            return;
        }
        this.hideButton();
        this.button = this.parent.createChild(-1, 5);
        this.button.setOriginalHeight(20);
        this.button.setOriginalWidth(20);
        this.button.setOriginalX(124);
        this.button.setOriginalY(14);
        this.button.setSpriteId(573);
        this.button.setAction(0, "Roll dice");
        this.button.setOnOpListener(new Object[]{e -> this.clientThread.invokeLater(this::trigger)});
        this.button.setHasListener(true);
        this.button.revalidate();
    }
}

