/*
 * Decompiled with CFR 0.152.
 */
package com.dice;

import com.dice.Dice;
import com.dice.DiceConfig;
import com.dice.DicePlugin;
import com.dice.DiceType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiceOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(DiceOverlay.class);
    private final Client client;
    private final DicePlugin plugin;
    private final DiceConfig config;
    private final ItemManager itemManager;
    private final SkillIconManager iconManager;
    private BufferedImage spritesheet;
    FontMetrics metrics;
    private Font font;
    private Font fontSmall;
    Dimension dims;
    private final List<Dice> dices = new LinkedList<Dice>();
    private boolean init = false;
    private boolean unannounced = true;
    private int putAwayTimer;

    @Inject
    DiceOverlay(Client client, DicePlugin plugin, DiceConfig config, ItemManager itemManager, SkillIconManager iconManager) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.itemManager = itemManager;
        this.iconManager = iconManager;
        this.spritesheet = ImageUtil.loadImageResource(DicePlugin.class, (String)"/spritesheet.png");
        this.font = FontManager.getRunescapeBoldFont();
        this.fontSmall = FontManager.getRunescapeSmallFont();
    }

    public void reset() {
        this.dices.clear();
        this.init = false;
    }

    public void init(Graphics2D g) {
        this.putAwayTimer = this.config.autoPutAwayTicks();
        g.setFont(this.font);
        this.metrics = g.getFontMetrics(this.font);
        this.init = true;
        this.unannounced = true;
        this.dims = this.client.getRealDimensions();
        int diceCount = this.config.diceCount();
        int specialsActive = this.countTrue(this.config.basicDice(), this.config.fishingDice(), this.config.jesterDice(), this.config.metalDice(), this.config.combatSkillDice(), this.config.skillDice());
        if (specialsActive > 0) {
            HashMap<DiceType, Boolean> specialDiceMap = new HashMap<DiceType, Boolean>(){
                {
                    this.put(DiceType.BASIC, DiceOverlay.this.config.basicDice());
                    this.put(DiceType.FISHING, DiceOverlay.this.config.fishingDice());
                    this.put(DiceType.JESTER, DiceOverlay.this.config.jesterDice());
                    this.put(DiceType.METALS, DiceOverlay.this.config.metalDice());
                    this.put(DiceType.COMBAT_SKILLS, DiceOverlay.this.config.combatSkillDice());
                    this.put(DiceType.SKILLS, DiceOverlay.this.config.skillDice());
                }
            };
            block2: while (diceCount > 0) {
                for (Map.Entry entry : specialDiceMap.entrySet()) {
                    DiceType diceType = (DiceType)((Object)entry.getKey());
                    Boolean diceActive = (Boolean)entry.getValue();
                    if (!diceActive.booleanValue()) continue;
                    if (diceCount <= 0) continue block2;
                    this.dices.add(new Dice(diceType, this.dims.width, this.dims.height, 0));
                    --diceCount;
                }
            }
        } else if (this.config.diceAdvancedNotation().length() > 0) {
            String[] notation;
            for (String notedDice : notation = this.config.diceAdvancedNotation().split("\\s+")) {
                try {
                    int magicSides = Integer.valueOf(notedDice.substring(1));
                    this.dices.add(new Dice(DiceType.MAGIC, this.dims.width, this.dims.height, magicSides));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            for (int i = 0; i < diceCount; ++i) {
                this.dices.add(new Dice(DiceType.BASIC, this.dims.width, this.dims.height, 0));
            }
        }
    }

    protected int countTrue(boolean ... vars) {
        int count = 0;
        for (boolean var : vars) {
            count += var ? 1 : 0;
        }
        return count;
    }

    public BufferedImage getSprite(int col, int row, int width, int height) {
        BufferedImage img = this.spritesheet.getSubimage(col * 16 - 16, row * 16 - 16, width, height);
        return img;
    }

    protected BufferedImage tint(float r, float g, float b, float a, BufferedImage sprite) {
        BufferedImage tintedSprite = new BufferedImage(sprite.getWidth(), sprite.getHeight(), 3);
        Graphics2D graphics = tintedSprite.createGraphics();
        graphics.drawImage((Image)sprite, 0, 0, null);
        graphics.dispose();
        for (int i = 0; i < tintedSprite.getWidth(); ++i) {
            for (int j = 0; j < tintedSprite.getHeight(); ++j) {
                int ax = tintedSprite.getColorModel().getAlpha(tintedSprite.getRaster().getDataElements(i, j, null));
                int rx = tintedSprite.getColorModel().getRed(tintedSprite.getRaster().getDataElements(i, j, null));
                int gx = tintedSprite.getColorModel().getGreen(tintedSprite.getRaster().getDataElements(i, j, null));
                int bx = tintedSprite.getColorModel().getBlue(tintedSprite.getRaster().getDataElements(i, j, null));
                rx = (int)((float)rx * r);
                gx = (int)((float)gx * g);
                bx = (int)((float)bx * b);
                ax = (int)((float)ax * a);
                tintedSprite.setRGB(i, j, ax << 24 | rx << 16 | gx << 8 | bx);
            }
        }
        return tintedSprite;
    }

    protected BufferedImage alpha(float a, BufferedImage sprite) {
        BufferedImage alphaSprite = new BufferedImage(sprite.getWidth(), sprite.getHeight(), 3);
        Graphics2D graphics = alphaSprite.createGraphics();
        graphics.drawImage((Image)sprite, 0, 0, null);
        graphics.dispose();
        for (int i = 0; i < alphaSprite.getWidth(); ++i) {
            for (int j = 0; j < alphaSprite.getHeight(); ++j) {
                int ax = alphaSprite.getColorModel().getAlpha(alphaSprite.getRaster().getDataElements(i, j, null));
                int rx = alphaSprite.getColorModel().getRed(alphaSprite.getRaster().getDataElements(i, j, null));
                int gx = alphaSprite.getColorModel().getGreen(alphaSprite.getRaster().getDataElements(i, j, null));
                int bx = alphaSprite.getColorModel().getBlue(alphaSprite.getRaster().getDataElements(i, j, null));
                ax = (int)((float)ax * a);
                alphaSprite.setRGB(i, j, ax << 24 | rx << 16 | gx << 8 | bx);
            }
        }
        return alphaSprite;
    }

    public static BufferedImage resize(BufferedImage sprite, int newW, int newH) {
        Image tmp = sprite.getScaledInstance(newW, newH, 4);
        BufferedImage newSprite = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = newSprite.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return newSprite;
    }

    public void drawCenteredString(Graphics g, String text, Dice dice, int offsetx, int offsety) {
        int x = dice.x + (32 - this.metrics.stringWidth(text)) / 2 + offsetx;
        int y = dice.y + (32 - this.metrics.getHeight()) / 2 + this.metrics.getAscent() + offsety;
        g.drawString(text, x, y);
    }

    public Dimension render(Graphics2D g) {
        if (this.init && this.plugin.ROLL_DICE) {
            boolean allDiceDead = true;
            boolean allDiceFallen = true;
            for (Dice dice : this.dices) {
                dice.next(this.dices);
                BufferedImage sprite = this.getSprite(dice.col, dice.row, 16, 16);
                Color tint = this.config.diceColor();
                float tintR = (float)tint.getRed() / 255.0f;
                float tintG = (float)tint.getGreen() / 255.0f;
                float tintB = (float)tint.getBlue() / 255.0f;
                if (!this.config.flashResults() || this.config.flashResults() && dice.life > 0 || this.config.flashResults() && dice.altFrame) {
                    sprite = this.tint(tintR, tintG, tintB, (float)this.config.diceOpacity() / 100.0f, sprite);
                }
                g.drawImage(sprite, dice.x, dice.y, 32, 32, null);
                if (dice.life <= 0 && dice.magicSides > 0 && dice.diceType != DiceType.BASIC && dice.diceType != DiceType.MAGIC) {
                    if (dice.result > 0) {
                        Object spriteImage = null;
                        if (dice.specialOutcomes.get(dice.result - 1).getSpecialSpriteId() > 0) {
                            spriteImage = this.itemManager.getImage(dice.specialOutcomes.get(dice.result - 1).getSpecialSpriteId());
                        } else if (dice.specialOutcomes.get(dice.result - 1).getSpecialSkill() != null) {
                            spriteImage = this.iconManager.getSkillImage(dice.specialOutcomes.get(dice.result - 1).getSpecialSkill());
                        }
                        if (spriteImage != null) {
                            spriteImage = this.alpha((float)this.config.diceOpacity() / 100.0f, (BufferedImage)spriteImage);
                            spriteImage = DiceOverlay.resize((BufferedImage)spriteImage, 24, 24);
                            g.drawImage((Image)spriteImage, dice.x + 4, dice.y + 4, 24, 24, null);
                        }
                    }
                } else if (dice.life <= 0 && dice.magicSides > 0 && dice.diceType == DiceType.MAGIC && dice.result > -1) {
                    g.setFont(this.font);
                    g.setColor(Color.BLACK);
                    this.drawCenteredString(g, "" + dice.result, dice, -1, -1);
                    this.drawCenteredString(g, "" + dice.result, dice, -1, 1);
                    this.drawCenteredString(g, "" + dice.result, dice, 1, 1);
                    this.drawCenteredString(g, "" + dice.result, dice, 1, -1);
                    g.setColor(this.config.diceDigitColor());
                    this.drawCenteredString(g, "" + dice.result, dice, 0, 0);
                }
                if (dice.life <= 0 && dice.result > -1 && this.config.labelDice()) {
                    g.setFont(this.fontSmall);
                    if (dice.magicSides > 0 && dice.diceType != DiceType.MAGIC && dice.diceType != DiceType.BASIC && dice.result > 0) {
                        g.setColor(Color.BLACK);
                        String specialDiceName = dice.specialOutcomes.get(dice.result - 1).getName();
                        g.drawString(specialDiceName, dice.x + 35, dice.y + 35);
                        g.drawString(specialDiceName, dice.x + 35, dice.y + 37);
                        g.drawString(specialDiceName, dice.x + 37, dice.y + 37);
                        g.drawString(specialDiceName, dice.x + 37, dice.y + 35);
                        g.setColor(Color.WHITE);
                        g.drawString(specialDiceName, dice.x + 36, dice.y + 36);
                    } else if (dice.magicSides > 0 && dice.diceType == DiceType.MAGIC) {
                        g.setColor(Color.BLACK);
                        g.drawString("D" + dice.magicSides, dice.x + 35, dice.y + 35);
                        g.drawString("D" + dice.magicSides, dice.x + 35, dice.y + 37);
                        g.drawString("D" + dice.magicSides, dice.x + 37, dice.y + 37);
                        g.drawString("D" + dice.magicSides, dice.x + 37, dice.y + 35);
                        g.setColor(Color.WHITE);
                        g.drawString("D" + dice.magicSides, dice.x + 36, dice.y + 36);
                    } else {
                        g.setColor(Color.BLACK);
                        g.drawString("D6", dice.x + 35, dice.y + 35);
                        g.drawString("D6", dice.x + 35, dice.y + 37);
                        g.drawString("D6", dice.x + 37, dice.y + 37);
                        g.drawString("D6", dice.x + 37, dice.y + 35);
                        g.setColor(Color.WHITE);
                        g.drawString("D6", dice.x + 36, dice.y + 36);
                    }
                }
                if (dice.life > 0 || dice.result == -1) {
                    allDiceDead = false;
                    allDiceFallen = false;
                    continue;
                }
                if (this.config.autoPutAway() && this.putAwayTimer < 0) {
                    dice.dead = true;
                    if (dice.y >= this.dims.height + 100) continue;
                    allDiceFallen = false;
                    dice.y += Math.abs(dice.yDrift) + 13;
                    continue;
                }
                allDiceFallen = false;
            }
            if (allDiceDead) {
                --this.putAwayTimer;
                if (this.unannounced) {
                    this.unannounced = false;
                    this.plugin.sayTotal(this.dices);
                }
            }
            if (this.config.autoPutAway() && allDiceDead && allDiceFallen) {
                this.plugin.trigger();
            }
        } else if (!this.init && this.plugin.ROLL_DICE) {
            this.init(g);
        } else {
            this.reset();
        }
        return null;
    }
}

