/*
 * Decompiled with CFR 0.152.
 */
package com.dice;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="Dice")
public interface DiceConfig
extends Config {
    @ConfigSection(name="Appearance", description="How the dice will appear on screen", position=1, closedByDefault=false)
    public static final String AppearanceSettings = "AppearanceSettings";
    @ConfigSection(name="Special Dice", description="Special dice you can use, these are divided evenly as possible.", position=2, closedByDefault=false)
    public static final String SpecialDiceSettings = "SpecialDiceSettings";

    @Range(min=1)
    @ConfigItem(keyName="diceCount", name="Number of Dice", description="Too many dice may prevent them ever settling!")
    default public int diceCount() {
        return 5;
    }

    @Range(min=1, max=100)
    @Units(value="%")
    @ConfigItem(section="AppearanceSettings", position=1, keyName="diceOpacity", name="Dice opacity", description="Do you want the dice see-through?")
    default public int diceOpacity() {
        return 100;
    }

    @ConfigItem(section="AppearanceSettings", position=2, keyName="flashResults", name="Flash Results", description="Flash Dice when they stop?")
    default public boolean flashResults() {
        return false;
    }

    @ConfigItem(section="AppearanceSettings", position=3, keyName="diceColor", name="Dice Color", description="The color of the dice.")
    default public Color diceColor() {
        return new Color(240, 231, 186);
    }

    @ConfigItem(section="AppearanceSettings", position=5, keyName="autoPutAway", name="Auto tidy", description="Put away dice after a few moments automatically?")
    default public boolean autoPutAway() {
        return true;
    }

    @Units(value=" ticks")
    @ConfigItem(section="AppearanceSettings", position=6, keyName="autoPutAwayTicks", name="Auto tidy delay", description="How quickly to auto tidy?")
    default public int autoPutAwayTicks() {
        return 120;
    }

    @ConfigItem(section="AppearanceSettings", position=7, keyName="labelDice", name="Label Dice", description="Show labels next to each dice?")
    default public boolean labelDice() {
        return true;
    }

    @ConfigItem(section="AppearanceSettings", position=8, keyName="diceDigitColor", name="Dice Digit Color", description="The color of the dice digits if using Advanced Notation.")
    default public Color diceDigitColor() {
        return new Color(255, 255, 255);
    }

    @ConfigItem(section="SpecialDiceSettings", position=9, keyName="basicDice", name="Basic Dice (D6)", description="Use basic dice?")
    default public boolean basicDice() {
        return false;
    }

    @ConfigItem(section="SpecialDiceSettings", position=10, keyName="fishingDice", name="Fishing Dice (D19)", description="Use fishing dice?")
    default public boolean fishingDice() {
        return false;
    }

    @ConfigItem(section="SpecialDiceSettings", position=11, keyName="jesterDice", name="Jester Dice (D6)", description="Use jester dice?")
    default public boolean jesterDice() {
        return false;
    }

    @ConfigItem(section="SpecialDiceSettings", position=12, keyName="metalDice", name="Metal Dice (D9)", description="Use metal dice?")
    default public boolean metalDice() {
        return false;
    }

    @ConfigItem(section="SpecialDiceSettings", position=13, keyName="skillDice", name="Skill Dice (D23)", description="Use skill dice?")
    default public boolean skillDice() {
        return false;
    }

    @ConfigItem(section="SpecialDiceSettings", position=14, keyName="combatSkillDice", name="Combat Skill Dice (D4)", description="Use combat skill dice?")
    default public boolean combatSkillDice() {
        return false;
    }

    @ConfigItem(section="SpecialDiceSettings", position=99, keyName="diceAdvancedNotation", name="Advanced Notation (optional)", description="Separate by spaces eg. D6 D6 D10 D20 D20<br><br>This overrides the above number of dice.<br><br>Leave blank if unsure!")
    default public String diceAdvancedNotation() {
        return "";
    }
}

