/*
 * Decompiled with CFR 0.152.
 */
package com.dice;

import com.dice.DiceType;
import com.dice.SpecialDice;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

class Dice {
    private Random r;
    DiceType diceType;
    int x;
    int y;
    int life;
    int col;
    int row;
    int finalRow;
    final int minLife = 30;
    final int maxLife = 80;
    private final int bezel = 100;
    int xDrift;
    int yDrift;
    int ticks;
    int speed;
    final int minSpeed = 3;
    final int maxSpeed = 10;
    int canvasWidth;
    int canvasHeight;
    boolean altFrame = false;
    int magicSides;
    List<SpecialDice> specialOutcomes;
    int result = -1;
    boolean dead = false;

    public Dice(DiceType diceType, int canvasWidth, int canvasHeight, int magicSides) {
        this.diceType = diceType;
        this.r = new Random();
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.x = canvasWidth / 2;
        this.y = canvasHeight / 2;
        this.x = 100 + this.r.nextInt(canvasWidth - 100 - 100 + 1);
        this.y = 100 + this.r.nextInt(canvasHeight - 100 - 100 + 1);
        this.life = 30 + this.r.nextInt(51);
        this.ticks = this.speed = 3 + this.r.nextInt(8);
        this.col = 1 + this.r.nextInt(6);
        this.row = 15;
        this.finalRow = 2 + this.r.nextInt(11);
        this.xDrift = -15 + this.r.nextInt(17);
        this.yDrift = -15 + this.r.nextInt(17);
        this.magicSides = magicSides;
        this.specialOutcomes = new ArrayList<SpecialDice>();
        if (this.diceType != DiceType.BASIC && this.diceType != DiceType.MAGIC) {
            for (SpecialDice sp : SpecialDice.values()) {
                if (sp.getDiceType() != this.diceType) continue;
                this.specialOutcomes.add(sp);
            }
            this.magicSides = this.specialOutcomes.size();
        }
    }

    public int getX() {
        return this.x;
    }

    private void drift() {
        if (this.x < 0 || this.x > this.canvasWidth - 32) {
            this.xDrift = -this.xDrift;
        }
        this.x += this.xDrift;
        if (this.y < 0 || this.y > this.canvasHeight - 32) {
            this.yDrift = -this.yDrift;
        }
        this.y += this.yDrift;
    }

    private void uncollide(List<Dice> siblings) {
        for (Dice sibling : siblings) {
            if (this == sibling || this.life > 0 || sibling.life > 0 || !this.overlaps(sibling)) continue;
            this.life = 10;
            this.speed = 5;
            this.row = 15;
        }
    }

    public boolean overlaps(Dice r) {
        return this.x < r.x + 32 && this.x + 32 > r.x && this.y < r.y + 32 && this.y + 32 > r.y;
    }

    public void next(List<Dice> siblings) {
        if (this.life > 0) {
            this.drift();
            --this.life;
        } else if (!this.dead) {
            this.uncollide(siblings);
        }
        if (this.ticks > 0) {
            --this.ticks;
        } else {
            boolean bl = this.altFrame = !this.altFrame;
            if (this.speed < 10) {
                ++this.speed;
            }
            if (this.life > 0) {
                this.ticks = this.speed;
                ++this.col;
                if (this.col > 6) {
                    this.col = 1;
                }
            } else {
                this.ticks = this.speed * 2;
                if (this.magicSides > 0 && this.diceType != DiceType.BASIC) {
                    this.row = 13;
                    this.col = 1;
                    if (this.result == -1) {
                        this.result = 1 + this.r.nextInt(this.magicSides - 1 + 1);
                    }
                } else {
                    this.row = 1;
                    this.result = this.col;
                }
            }
        }
    }
}

