/*
 * Decompiled with CFR 0.152.
 */
package com.randomscreenshot;

import com.google.inject.Provides;
import com.randomscreenshot.RandomScreenshotConfig;
import com.randomscreenshot.ScreenshotUtil;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Random Screenshot", description="Randomly take screenshots as you go about your adventures", tags={"screenshot", "images", "random", "memories"})
public class RandomScreenshotPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RandomScreenshotPlugin.class);
    static final String CONFIG_GROUP_KEY = "randomscreenshot";
    @Inject
    private RandomScreenshotConfig config;
    @Inject
    private ScreenshotUtil screenShotUtil;
    @Inject
    private Client client;
    private final Random rand = new Random(System.currentTimeMillis());

    @Provides
    RandomScreenshotConfig getConfig(ConfigManager configManager) {
        return (RandomScreenshotConfig)configManager.getConfig(RandomScreenshotConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.shouldTakeScreenshot()) {
            this.takeScreenshot();
        }
    }

    private boolean shouldTakeScreenshot() {
        if (this.isBankPinContainerVisible() || this.isOnLoginScreen()) {
            return false;
        }
        return this.rand.nextInt(this.config.sampleWeight()) == 0;
    }

    private void takeScreenshot() {
        this.screenShotUtil.takeScreenshot();
    }

    private boolean isBankPinContainerVisible() {
        Widget pinContainer = this.client.getWidget(0xD50000);
        if (pinContainer == null) {
            return true;
        }
        return !pinContainer.isSelfHidden();
    }

    private boolean isOnLoginScreen() {
        return this.client.getGameState() == GameState.LOGIN_SCREEN;
    }
}

