/*
 * Decompiled with CFR 0.152.
 */
package com.gauntletminimap.resourcenode;

import com.gauntletminimap.MinimapRenderable;
import java.awt.image.BufferedImage;
import net.runelite.api.GameObject;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.client.game.SkillIconManager;

public abstract class ResourceNode
implements MinimapRenderable {
    private final GameObject gameObject;
    private final BufferedImage image;

    protected ResourceNode(GameObject gameObject, Skill skill) {
        this.gameObject = gameObject;
        this.image = new SkillIconManager().getSkillImage(skill, true);
    }

    public GameObject getGameObject() {
        return this.gameObject;
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public Point getMinimapLocation() {
        Point point = this.gameObject.getMinimapLocation();
        if (point == null) {
            return null;
        }
        return new Point(point.getX() - this.image.getHeight() / 2, point.getY() - this.image.getWidth() / 2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.gameObject.equals(((ResourceNode)o).getGameObject());
    }

    public int hashCode() {
        return this.gameObject.hashCode();
    }
}

