/*
 * Decompiled with CFR 0.152.
 */
package com.gauntletminimap.demiboss;

import com.gauntletminimap.MinimapRenderable;
import java.awt.image.BufferedImage;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.client.game.SkillIconManager;

public abstract class DemiBoss
implements MinimapRenderable {
    private final NPC npc;
    private final BufferedImage image;

    protected DemiBoss(NPC npc, Skill skill) {
        this.npc = npc;
        this.image = new SkillIconManager().getSkillImage(skill, true);
    }

    public NPC getNpc() {
        return this.npc;
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public Point getMinimapLocation() {
        Point point = this.npc.getMinimapLocation();
        if (point == null) {
            return null;
        }
        return new Point(point.getX() - this.image.getHeight() / 2, point.getY() - this.image.getWidth() / 2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.npc.equals(((DemiBoss)o).getNpc());
    }

    public int hashCode() {
        return this.npc.hashCode();
    }
}

