/*
 * Decompiled with CFR 0.152.
 */
package com.gauntletminimap;

import com.gauntletminimap.GauntletMinimapConfig;
import com.gauntletminimap.GauntletMinimapOverlay;
import com.gauntletminimap.demiboss.Bear;
import com.gauntletminimap.demiboss.DarkBeast;
import com.gauntletminimap.demiboss.DemiBoss;
import com.gauntletminimap.demiboss.Dragon;
import com.gauntletminimap.resourcenode.FishingSpot;
import com.gauntletminimap.resourcenode.GrymRoot;
import com.gauntletminimap.resourcenode.LinumTirinum;
import com.gauntletminimap.resourcenode.OreDeposit;
import com.gauntletminimap.resourcenode.PhrenRoot;
import com.gauntletminimap.resourcenode.ResourceNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Gauntlet Minimap", description="Displays the resource nodes of the Gauntlet on your minimap", tags={"corrupted", "gauntlet", "resource", "nodes", "demi-boss", "demiboss", "minimap", "hunllef", "pve", "pvm", "minigame"})
public class GauntletMinimapPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GauntletMinimapPlugin.class);
    @Inject
    private Client client;
    @Inject
    private GauntletMinimapConfig config;
    @Inject
    private GauntletMinimapOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private boolean isStarted = false;
    private static final int CRYSTAL_GAUNTLET_REGION_ID = 7512;
    private static final int CORRUPTED_GAUNTLET_REGION_ID = 7768;
    private static final String MINING_MESSAGE = "You manage to mine some ore.";
    private static final String WOODCUTTING_MESSAGE = "You get some bark.";
    private static final String FARMING_MESSAGE = "You pick some fibre from the plant.";
    private static final String HERBLORE_MESSAGE = "You pick a herb from the roots.";
    private static final String FISHING_MESSAGE = "You manage to catch a fish.";
    protected final Set<ResourceNode> resourceNodes = new HashSet<ResourceNode>();
    protected final Set<DemiBoss> demiBosses = new HashSet<DemiBoss>();
    protected boolean trackResources;
    protected Map<String, Integer> maxResources;
    protected Map<String, Integer> collectedResources = new HashMap<String, Integer>(){
        {
            this.put(OreDeposit.class.getSimpleName(), 0);
            this.put(PhrenRoot.class.getSimpleName(), 0);
            this.put(LinumTirinum.class.getSimpleName(), 0);
            this.put(GrymRoot.class.getSimpleName(), 0);
            this.put(FishingSpot.class.getSimpleName(), 0);
        }
    };
    protected Set<String> displayableItems = new HashSet<String>();
    private static final Set<Integer> RESOURCE_NODE_IDS = ImmutableSet.of((Object)36064, (Object)35967, (Object)36066, (Object)35969, (Object)36072, (Object)35975, (Object[])new Integer[]{36070, 35973, 36068, 35971});
    private static final Set<Integer> DEMI_BOSS_IDS = ImmutableSet.of((Object)9032, (Object)9046, (Object)9033, (Object)9047, (Object)9034, (Object)9048, (Object[])new Integer[0]);

    protected void startUp() {
        this.resourceNodes.clear();
        if (!this.isStarted) {
            this.isStarted = true;
            this.setConfigs();
            if (this.isInGauntlet()) {
                this.overlayManager.add((Overlay)this.overlay);
            }
        }
    }

    protected void shutDown() {
        if (this.isStarted) {
            this.isStarted = false;
            this.overlayManager.remove((Overlay)this.overlay);
            this.resourceNodes.clear();
            this.collectedResources = new HashMap<String, Integer>(){
                {
                    this.put(OreDeposit.class.getSimpleName(), 0);
                    this.put(PhrenRoot.class.getSimpleName(), 0);
                    this.put(LinumTirinum.class.getSimpleName(), 0);
                    this.put(GrymRoot.class.getSimpleName(), 0);
                    this.put(FishingSpot.class.getSimpleName(), 0);
                }
            };
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOADING: {
                if (this.isInGauntlet()) {
                    this.startUp();
                    break;
                }
                this.shutDown();
                break;
            }
            case LOGIN_SCREEN: 
            case HOPPING: {
                this.shutDown();
                break;
            }
        }
    }

    @Subscribe
    private void onGameObjectSpawned(GameObjectSpawned event) {
        if (!this.isInGauntlet()) {
            return;
        }
        GameObject gameObject = event.getGameObject();
        if (RESOURCE_NODE_IDS.contains(gameObject.getId())) {
            this.resourceNodes.add(this.gameObjectToResource(gameObject));
        }
    }

    @Subscribe
    private void onGameObjectDespawned(GameObjectDespawned event) {
        if (!this.isInGauntlet()) {
            return;
        }
        GameObject gameObject = event.getGameObject();
        if (RESOURCE_NODE_IDS.contains(gameObject.getId())) {
            this.resourceNodes.remove(this.gameObjectToResource(gameObject));
        }
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned event) {
        if (!this.isInGauntlet()) {
            return;
        }
        NPC npc = event.getNpc();
        if (DEMI_BOSS_IDS.contains(npc.getId())) {
            this.demiBosses.add(this.npcToDemiBoss(npc));
        }
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned event) {
        if (!this.isInGauntlet()) {
            return;
        }
        NPC npc = event.getNpc();
        if (DEMI_BOSS_IDS.contains(npc.getId())) {
            this.demiBosses.remove(this.npcToDemiBoss(npc));
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("gauntletMinimap")) {
            return;
        }
        this.setConfigs();
    }

    @Subscribe
    private void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.SPAM) {
            switch (event.getMessage()) {
                case "You manage to mine some ore.": {
                    this.collectedResources.merge(OreDeposit.class.getSimpleName(), 1, Integer::sum);
                    break;
                }
                case "You get some bark.": {
                    this.collectedResources.merge(PhrenRoot.class.getSimpleName(), 1, Integer::sum);
                    break;
                }
                case "You pick some fibre from the plant.": {
                    this.collectedResources.merge(LinumTirinum.class.getSimpleName(), 1, Integer::sum);
                    break;
                }
                case "You pick a herb from the roots.": {
                    this.collectedResources.merge(GrymRoot.class.getSimpleName(), 1, Integer::sum);
                    break;
                }
                case "You manage to catch a fish.": {
                    this.collectedResources.merge(FishingSpot.class.getSimpleName(), 1, Integer::sum);
                    break;
                }
            }
        }
    }

    @Provides
    GauntletMinimapConfig provideConfig(ConfigManager configManager) {
        return (GauntletMinimapConfig)configManager.getConfig(GauntletMinimapConfig.class);
    }

    private ResourceNode gameObjectToResource(GameObject gameObject) {
        switch (gameObject.getId()) {
            case 35967: 
            case 36064: {
                return new OreDeposit(gameObject);
            }
            case 35969: 
            case 36066: {
                return new PhrenRoot(gameObject);
            }
            case 35975: 
            case 36072: {
                return new LinumTirinum(gameObject);
            }
            case 35973: 
            case 36070: {
                return new GrymRoot(gameObject);
            }
            case 35971: 
            case 36068: {
                return new FishingSpot(gameObject);
            }
        }
        return null;
    }

    private DemiBoss npcToDemiBoss(NPC npc) {
        switch (npc.getId()) {
            case 9032: 
            case 9046: {
                return new Bear(npc);
            }
            case 9033: 
            case 9047: {
                return new Dragon(npc);
            }
            case 9034: 
            case 9048: {
                return new DarkBeast(npc);
            }
        }
        return null;
    }

    private void setConfigs() {
        this.updateDisplayableItems(this.config.oreDeposit(), OreDeposit.class.getSimpleName());
        this.updateDisplayableItems(this.config.phrenRoots(), PhrenRoot.class.getSimpleName());
        this.updateDisplayableItems(this.config.linumTirinum(), LinumTirinum.class.getSimpleName());
        this.updateDisplayableItems(this.config.grymRoot(), GrymRoot.class.getSimpleName());
        this.updateDisplayableItems(this.config.fishingSpot(), FishingSpot.class.getSimpleName());
        this.updateDisplayableItems(this.config.bear(), Bear.class.getSimpleName());
        this.updateDisplayableItems(this.config.dragon(), Dragon.class.getSimpleName());
        this.updateDisplayableItems(this.config.darkBeast(), DarkBeast.class.getSimpleName());
        this.trackResources = this.config.trackResources();
        this.maxResources = ImmutableMap.of((Object)OreDeposit.class.getSimpleName(), (Object)this.config.ore(), (Object)PhrenRoot.class.getSimpleName(), (Object)this.config.bark(), (Object)LinumTirinum.class.getSimpleName(), (Object)this.config.fibre(), (Object)GrymRoot.class.getSimpleName(), (Object)this.config.herb(), (Object)FishingSpot.class.getSimpleName(), (Object)this.config.fish());
    }

    private void updateDisplayableItems(boolean add, String className) {
        if (add) {
            this.displayableItems.add(className);
        } else {
            this.displayableItems.remove(className);
        }
    }

    protected boolean isDemiboss(String className) {
        return className.equals(Bear.class.getSimpleName()) || className.equals(Dragon.class.getSimpleName()) || className.equals(DarkBeast.class.getSimpleName());
    }

    public boolean isInNormal() {
        if (this.client.getLocalPlayer() == null) {
            return false;
        }
        return this.client.getMapRegions()[0] == 7512;
    }

    public boolean isInCorrupted() {
        if (this.client.getLocalPlayer() == null) {
            return false;
        }
        return this.client.getMapRegions()[0] == 7768;
    }

    private boolean isInGauntlet() {
        return this.isInNormal() || this.isInCorrupted();
    }
}

