/*
 * Decompiled with CFR 0.152.
 */
package com.gauntletminimap;

import com.gauntletminimap.GauntletMinimapPlugin;
import com.gauntletminimap.MinimapRenderable;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class GauntletMinimapOverlay
extends Overlay {
    private final GauntletMinimapPlugin plugin;

    @Inject
    private GauntletMinimapOverlay(GauntletMinimapPlugin plugin) {
        this.plugin = plugin;
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
    }

    public Dimension render(Graphics2D graphics) {
        this.plugin.resourceNodes.forEach(node -> this.renderImageOnMinimap(graphics, (MinimapRenderable)node));
        this.plugin.demiBosses.forEach(demiBoss -> this.renderImageOnMinimap(graphics, (MinimapRenderable)demiBoss));
        return null;
    }

    private void renderImageOnMinimap(Graphics2D graphics, MinimapRenderable minimapRenderable) {
        String className = minimapRenderable.getClass().getSimpleName();
        if (!this.plugin.displayableItems.contains(className) || this.plugin.trackResources && !this.plugin.isDemiboss(className) && this.plugin.collectedResources.get(className) >= this.plugin.maxResources.get(className)) {
            return;
        }
        Point minimapLocation = minimapRenderable.getMinimapLocation();
        if (minimapLocation != null) {
            OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)minimapLocation, (BufferedImage)minimapRenderable.getImage());
        }
    }
}

