/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.discordlootlogger;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.inject.Provides;
import info.sigterm.plugins.discordlootlogger.DiscordLootLoggerConfig;
import info.sigterm.plugins.discordlootlogger.WebhookBody;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.NPC;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.loottracker.LootRecordType;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Loot Logger")
public class DiscordLootLoggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordLootLoggerPlugin.class);
    @Inject
    private DiscordLootLoggerConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private DrawManager drawManager;
    private List<String> lootNpcs;
    @Inject
    private Client client;

    private static String itemImageUrl(int itemId) {
        return "https://static.runelite.net/cache/item/icon/" + itemId + ".png";
    }

    protected void startUp() {
        this.lootNpcs = Collections.emptyList();
    }

    protected void shutDown() {
    }

    @Provides
    DiscordLootLoggerConfig provideConfig(ConfigManager configManager) {
        return (DiscordLootLoggerConfig)configManager.getConfig(DiscordLootLoggerConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equalsIgnoreCase("discordlootlogger")) {
            String s = this.config.lootNpcs();
            this.lootNpcs = s != null ? Text.fromCSV((String)s) : Collections.emptyList();
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        NPC npc = npcLootReceived.getNpc();
        Collection items = npcLootReceived.getItems();
        if (!this.lootNpcs.isEmpty()) {
            for (String npcName : this.lootNpcs) {
                if (!WildcardMatcher.matches((String)npcName, (String)npc.getName())) continue;
                this.processLoot(npc.getName(), items);
                return;
            }
        } else {
            this.processLoot(npc.getName(), items);
        }
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        Collection items = playerLootReceived.getItems();
        this.processLoot(playerLootReceived.getPlayer().getName(), items);
    }

    @Subscribe
    public void onLootReceived(LootReceived lootReceived) {
        if (lootReceived.getType() != LootRecordType.EVENT && lootReceived.getType() != LootRecordType.PICKPOCKET) {
            return;
        }
        this.processLoot(lootReceived.getName(), lootReceived.getItems());
    }

    private String getPlayerName() {
        return this.client.getLocalPlayer().getName();
    }

    private void processLoot(String name, Collection<ItemStack> items) {
        WebhookBody webhookBody = new WebhookBody();
        boolean sendMessage = false;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.config.includeUsername()) {
            stringBuilder.append("\n**").append(this.getPlayerName()).append("**").append(":\n\n");
        }
        stringBuilder.append("***").append(name).append("***").append(":\n");
        int targetValue = this.config.lootValue();
        for (ItemStack item : DiscordLootLoggerPlugin.stack(items)) {
            int itemId = item.getId();
            int qty = item.getQuantity();
            int price = this.itemManager.getItemPrice(itemId);
            long total = (long)price * (long)qty;
            if (!this.config.includeLowValueItems() && total < (long)targetValue) continue;
            sendMessage = true;
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            stringBuilder.append("*").append(qty).append(" x ").append(itemComposition.getName()).append("*");
            if (this.config.stackValue()) {
                stringBuilder.append(" (").append(QuantityFormatter.quantityToStackSize((long)total)).append(")");
            }
            stringBuilder.append("\n");
            webhookBody.getEmbeds().add(new WebhookBody.Embed(new WebhookBody.UrlEmbed(DiscordLootLoggerPlugin.itemImageUrl(itemId))));
        }
        if (sendMessage) {
            webhookBody.setContent(stringBuilder.toString());
            this.sendWebhook(webhookBody);
        }
    }

    private void sendWebhook(WebhookBody webhookBody) {
        String configUrls = this.config.webhook();
        if (Strings.isNullOrEmpty((String)configUrls)) {
            return;
        }
        if (this.config.sendScreenshot()) {
            this.drawManager.requestNextFrameListener(image -> {
                BufferedImage bufferedImage = (BufferedImage)image;
                byte[] imageBytes = null;
                try {
                    imageBytes = DiscordLootLoggerPlugin.convertImageToByteArray(bufferedImage);
                }
                catch (IOException e) {
                    log.error("Error converting image to byte array", (Throwable)e);
                }
                this.sendWebhook(webhookBody, imageBytes);
            });
        } else {
            this.sendWebhook(webhookBody, null);
        }
    }

    private void sendWebhook(WebhookBody webhookBody, byte[] screenshot) {
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)webhookBody));
        if (screenshot != null) {
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])screenshot));
        }
        MultipartBody requestBody = requestBodyBuilder.build();
        List urls = Splitter.on((String)"\n").omitEmptyStrings().trimResults().splitToList((CharSequence)this.config.webhook());
        for (String url : urls) {
            HttpUrl u = HttpUrl.parse((String)url);
            if (u == null) {
                log.info("Malformed webhook url {}", (Object)url);
                continue;
            }
            Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.debug("Error submitting webhook", (Throwable)e);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    response.close();
                }
            });
        }
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static Collection<ItemStack> stack(Collection<ItemStack> items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            int quantity = 0;
            for (ItemStack i : list) {
                if (i.getId() != item.getId()) continue;
                quantity = i.getQuantity();
                list.remove(i);
                break;
            }
            if (quantity > 0) {
                list.add(new ItemStack(item.getId(), item.getQuantity() + quantity, item.getLocation()));
                continue;
            }
            list.add(item);
        }
        return list;
    }
}

