/*
 * Decompiled with CFR 0.152.
 */
package com.molopl.plugins.friendsviewer;

import com.google.inject.Provides;
import com.molopl.plugins.friendsviewer.FriendsViewerConfig;
import com.molopl.plugins.friendsviewer.FriendsViewerEntry;
import com.molopl.plugins.friendsviewer.FriendsViewerIconManager;
import com.molopl.plugins.friendsviewer.FriendsViewerOverlay;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Friend;
import net.runelite.api.FriendContainer;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.GameState;
import net.runelite.api.Nameable;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.clan.ClanSettings;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Friends and Clan Viewer", description="Always see clanmates and friends when they are online", tags={"friends", "list", "viewer", "online", "clan", "cc"})
public class FriendsViewerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FriendsViewerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private FriendsViewerIconManager iconManager;
    @Inject
    private FriendsViewerConfig config;
    private FriendsViewerOverlay friendsOverlay;
    private FriendsViewerOverlay chatChannelOverlay;
    private FriendsViewerOverlay yourClanOverlay;
    private FriendsViewerOverlay guestClanOverlay;

    protected void startUp() {
        this.clientThread.invokeLater(() -> {
            if (this.client.getGameState().getState() > GameState.STARTING.getState()) {
                this.iconManager.loadRankIcons();
            }
        });
        this.friendsOverlay = new FriendsViewerOverlay(this.client, this.config, "Friends", this.config::showFriends);
        this.chatChannelOverlay = new FriendsViewerOverlay(this.client, this.config, "Chat-channel", this.config::showChatChannel);
        this.yourClanOverlay = new FriendsViewerOverlay(this.client, this.config, "Your Clan", this.config::showYourClan);
        this.guestClanOverlay = new FriendsViewerOverlay(this.client, this.config, "Guest Clan", this.config::showGuestClan);
        this.overlayManager.add((Overlay)this.friendsOverlay);
        this.overlayManager.add((Overlay)this.chatChannelOverlay);
        this.overlayManager.add((Overlay)this.yourClanOverlay);
        this.overlayManager.add((Overlay)this.guestClanOverlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.friendsOverlay);
        this.overlayManager.remove((Overlay)this.chatChannelOverlay);
        this.overlayManager.remove((Overlay)this.yourClanOverlay);
        this.overlayManager.remove((Overlay)this.guestClanOverlay);
    }

    @Provides
    public FriendsViewerConfig provideConfig(ConfigManager configManager) {
        return (FriendsViewerConfig)configManager.getConfig(FriendsViewerConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGIN_SCREEN) {
            return;
        }
        this.iconManager.loadRankIcons();
        this.friendsOverlay.setEntries(null);
        this.chatChannelOverlay.setEntries(null);
        this.yourClanOverlay.setEntries(null);
        this.guestClanOverlay.setEntries(null);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.getTickCount() % 5 != 0) {
            return;
        }
        this.updateFriends(this.config.showFriends());
        this.updateChatChannel(this.config.showChatChannel());
        this.updateClan(this.config.showYourClan(), this.yourClanOverlay, this.client.getClanChannel(), this.client.getClanSettings());
        this.updateClan(this.config.showGuestClan(), this.guestClanOverlay, this.client.getGuestClanChannel(), this.client.getGuestClanSettings());
    }

    private void updateFriends(boolean enabled) {
        FriendContainer friendContainer = this.client.getFriendContainer();
        if (!enabled || friendContainer == null) {
            this.friendsOverlay.setEntries(null);
            return;
        }
        this.friendsOverlay.setEntries(Arrays.stream((Friend[])friendContainer.getMembers()).filter(friend -> friend.getWorld() > 0).sorted(Comparator.comparing(Nameable::getName, String::compareToIgnoreCase)).map(friend -> new FriendsViewerEntry(Text.toJagexName((String)friend.getName()), friend.getWorld(), null)).collect(Collectors.toList()));
    }

    private void updateChatChannel(boolean enabled) {
        FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
        if (!enabled || friendsChatManager == null) {
            this.chatChannelOverlay.setEntries(null);
            return;
        }
        this.chatChannelOverlay.setEntries(Arrays.stream((FriendsChatMember[])friendsChatManager.getMembers()).filter(clanmate -> !Text.toJagexName((String)clanmate.getName()).equals(this.getLocalPlayerName())).sorted(Comparator.comparing(FriendsChatMember::getRank).reversed().thenComparing(Nameable::getName, String::compareToIgnoreCase)).map(clanmate -> new FriendsViewerEntry(Text.toJagexName((String)clanmate.getName()), clanmate.getWorld(), this.iconManager.getRankImage(clanmate.getRank()))).collect(Collectors.toList()));
    }

    private void updateClan(boolean enabled, FriendsViewerOverlay overlay, ClanChannel clanChannel, ClanSettings clanSettings) {
        if (!enabled || clanChannel == null || clanSettings == null) {
            overlay.setEntries(null);
            return;
        }
        overlay.setEntries(clanChannel.getMembers().stream().filter(clanmate -> !Text.toJagexName((String)clanmate.getName()).equals(this.getLocalPlayerName())).sorted(Comparator.comparing(ClanChannelMember::getRank).reversed().thenComparing(ClanChannelMember::getName, String::compareToIgnoreCase)).map(clanmate -> new FriendsViewerEntry(Text.toJagexName((String)clanmate.getName()), clanmate.getWorld(), Optional.ofNullable(clanSettings.titleForRank(clanmate.getRank())).map(this.iconManager::getRankImage).orElse(null))).collect(Collectors.toList()));
    }

    private String getLocalPlayerName() {
        return Optional.ofNullable(this.client.getLocalPlayer()).map(Actor::getName).map(Text::toJagexName).orElse(null);
    }
}

