/*
 * Decompiled with CFR 0.152.
 */
package com.molopl.plugins.friendsviewer;

import com.molopl.plugins.friendsviewer.FriendsViewerConfig;
import com.molopl.plugins.friendsviewer.FriendsViewerEntry;
import com.molopl.plugins.friendsviewer.FriendsViewerIconManager;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.List;
import java.util.function.Supplier;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.SplitComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class FriendsViewerOverlay
extends OverlayPanel {
    private final Client client;
    private final FriendsViewerConfig config;
    private final String title;
    private final Supplier<Boolean> enabled;
    private List<FriendsViewerEntry> entries;

    public FriendsViewerOverlay(Client client, FriendsViewerConfig config, String title, Supplier<Boolean> enabled) {
        this.client = client;
        this.config = config;
        this.title = title;
        this.enabled = enabled;
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.panelComponent.setPreferredSize(new Dimension(129 + FriendsViewerIconManager.IMAGE_DIMENSION.width, 0));
    }

    public String getName() {
        return super.getName() + "-" + this.title;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.entries == null || !this.enabled.get().booleanValue()) {
            return null;
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text(String.format("%s (%d)", this.title, this.entries.size())).build());
        this.entries.stream().limit(this.config.maxPlayers()).map(this::toRenderableEntity).forEach(this.panelComponent.getChildren()::add);
        if (this.entries.size() > this.config.maxPlayers()) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text(String.format("... %d more", this.entries.size() - this.config.maxPlayers())).build());
        }
        return super.render(graphics);
    }

    private LayoutableRenderableEntity toRenderableEntity(FriendsViewerEntry entry) {
        LineComponent line = LineComponent.builder().left(entry.getName()).right("W" + entry.getWorld()).rightColor(entry.getWorld() == this.client.getWorld() ? this.config.sameWorldColor() : this.config.differentWorldColor()).build();
        return entry.getIcon() != null ? SplitComponent.builder().orientation(ComponentOrientation.HORIZONTAL).first((LayoutableRenderableEntity)new ImageComponent(entry.getIcon())).second((LayoutableRenderableEntity)line).gap(new Point(1, 0)).build() : line;
    }

    public List<FriendsViewerEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<FriendsViewerEntry> entries) {
        this.entries = entries;
    }
}

