/*
 * Decompiled with CFR 0.152.
 */
package com.molopl.plugins.friendsviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.FriendsChatRank;
import net.runelite.api.clan.ClanTitle;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.util.ImageUtil;

public class FriendsViewerIconManager {
    public static final Dimension IMAGE_DIMENSION = new Dimension(14, 14);
    private static final Color IMAGE_OUTLINE_COLOR = new Color(33, 33, 33);
    private static final int IMAGE_TOP_MARGIN = 2;
    private final Client client;
    private final SpriteManager spriteManager;
    private BufferedImage[] friendsChatRankImages;
    private BufferedImage[] clanRankImages;

    @Inject
    private FriendsViewerIconManager(Client client, SpriteManager spriteManager) {
        this.client = client;
        this.spriteManager = spriteManager;
    }

    @Nullable
    public BufferedImage getRankImage(FriendsChatRank friendsChatRank) {
        if (this.friendsChatRankImages == null || friendsChatRank == FriendsChatRank.UNRANKED) {
            return null;
        }
        return this.friendsChatRankImages[friendsChatRank.ordinal() - 1];
    }

    @Nullable
    public BufferedImage getRankImage(ClanTitle clanTitle) {
        if (this.clanRankImages == null) {
            return null;
        }
        int rank = clanTitle.getId();
        int idx = FriendsViewerIconManager.clanRankToIdx(rank);
        return this.clanRankImages[idx];
    }

    public void loadRankIcons() {
        int i;
        if (this.friendsChatRankImages != null) {
            return;
        }
        EnumComposition friendsChatIcons = this.client.getEnum(1543);
        EnumComposition clanIcons = this.client.getEnum(3798);
        this.friendsChatRankImages = new BufferedImage[friendsChatIcons.size()];
        this.clanRankImages = new BufferedImage[clanIcons.size()];
        for (i = 0; i < friendsChatIcons.size(); ++i) {
            int idx = i;
            this.spriteManager.getSpriteAsync(friendsChatIcons.getIntValue(friendsChatIcons.getKeys()[i]), 0, sprite -> {
                this.friendsChatRankImages[idx] = FriendsViewerIconManager.prepareImage(sprite, true);
            });
        }
        for (i = 0; i < clanIcons.size(); ++i) {
            int key = clanIcons.getKeys()[i];
            int idx = FriendsViewerIconManager.clanRankToIdx(key);
            this.spriteManager.getSpriteAsync(clanIcons.getIntValue(key), 0, sprite -> {
                this.clanRankImages[idx] = FriendsViewerIconManager.prepareImage(sprite, false);
            });
        }
    }

    private static BufferedImage prepareImage(BufferedImage sprite, boolean outline) {
        return Optional.ofNullable(sprite).map(image -> ImageUtil.resizeCanvas((BufferedImage)image, (int)FriendsViewerIconManager.IMAGE_DIMENSION.width, (int)FriendsViewerIconManager.IMAGE_DIMENSION.height)).map(image -> outline ? ImageUtil.outlineImage((BufferedImage)image, (Color)IMAGE_OUTLINE_COLOR) : image).map(FriendsViewerIconManager::addMargin).orElse(null);
    }

    private static BufferedImage addMargin(BufferedImage sprite) {
        BufferedImage newImage = new BufferedImage(sprite.getWidth(), sprite.getHeight() + 2, 2);
        Graphics2D graphics = newImage.createGraphics();
        graphics.drawImage((Image)sprite, 0, 2, null);
        graphics.dispose();
        return newImage;
    }

    private static int clanRankToIdx(int key) {
        return key < 0 ? ~key : key + 5;
    }
}

