/*
 * Decompiled with CFR 0.152.
 */
package com.slayertaghighlight;

import com.google.inject.Provides;
import com.slayertaghighlight.SlayerTagHighlightConfig;
import com.slayertaghighlight.SlayerTagHighlightMinimapOverlay;
import com.slayertaghighlight.SlayerTagHighlightOverlay;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.slayer.SlayerPlugin;
import net.runelite.client.plugins.slayer.SlayerPluginService;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Slayer Tag Highlight", description="Highlights on task NPCs that aren't tagged yet (not interacting with you)", tags={"Slayer", "Tag", "Highlight", "NPC"})
@PluginDependency(value=SlayerPlugin.class)
public class SlayerTagHighlightPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SlayerTagHighlightPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SlayerTagHighlightOverlay overlay;
    @Inject
    private SlayerTagHighlightMinimapOverlay minimapOverlay;
    @Inject
    private SlayerTagHighlightConfig config;
    @Inject
    private SlayerPluginService slayerPluginService;
    @Inject
    private PluginManager pluginManager;
    private ArrayList<NPC> highlights = new ArrayList();
    private List<String> filterNames;

    @Provides
    SlayerTagHighlightConfig getConfig(ConfigManager configManager) {
        return (SlayerTagHighlightConfig)configManager.getConfig(SlayerTagHighlightConfig.class);
    }

    protected void startUp() {
        Optional<Plugin> slayerPlugin = this.pluginManager.getPlugins().stream().filter(p -> p.getName().equals("Slayer")).findFirst();
        if (slayerPlugin.isPresent() && this.pluginManager.isPluginEnabled(slayerPlugin.get())) {
            this.pluginManager.setPluginEnabled(slayerPlugin.get(), true);
        }
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.filterNames = Text.fromCSV((String)this.config.filterList());
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.highlights.clear();
        for (NPC npc : this.client.getNpcs()) {
            if (!this.slayerPluginService.getTargets().contains(npc) || this.highlights.contains(npc) || npc.isInteracting() || npc.isDead() || !this.highlightMatchesNPCName(npc.getName()) && this.config.filterByList()) continue;
            this.highlights.add(npc);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuEntry menuEntry = event.getMenuEntry();
        NPC npc = menuEntry.getNpc();
        if (this.highlights.contains(npc) && this.config.menuHighlight()) {
            String string = ColorUtil.prependColorTag((String)Text.removeTags((String)event.getTarget()), (Color)this.config.highlightColor());
            menuEntry.setTarget(string);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getKey().equals("filterList")) {
            this.filterNames = Text.fromCSV((String)this.config.filterList());
        }
    }

    private boolean highlightMatchesNPCName(String npcName) {
        for (String filterName : this.filterNames) {
            if (!WildcardMatcher.matches((String)filterName, (String)npcName)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<NPC> getHighlights() {
        return this.highlights;
    }
}

