/*
 * Decompiled with CFR 0.152.
 */
package com.slayertaghighlight;

import com.slayertaghighlight.SlayerTagHighlightConfig;
import com.slayertaghighlight.SlayerTagHighlightPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

public class SlayerTagHighlightOverlay
extends Overlay {
    @Inject
    private Client client;
    @Inject
    private SlayerTagHighlightPlugin plugin;
    @Inject
    private SlayerTagHighlightConfig config;
    private ModelOutlineRenderer modelOutlineRenderer;

    @Inject
    private SlayerTagHighlightOverlay(Client client, SlayerTagHighlightPlugin plugin, SlayerTagHighlightConfig config, ModelOutlineRenderer modelOutlineRenderer) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        for (NPC npc : this.plugin.getHighlights()) {
            Color configColor = this.config.highlightColor();
            this.renderNpcOverlay(graphics, npc, configColor);
        }
        return null;
    }

    private void renderNpcOverlay(Graphics2D graphics, NPC npc, Color color) {
        Shape shape;
        if (this.config.hullHighlight() && (shape = npc.getConvexHull()) != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke((float)this.config.outlineWidth()));
            graphics.draw(shape);
        }
        if (this.config.areaHighlight() && (shape = npc.getConvexHull()) != null) {
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 50));
            graphics.fill(shape);
        }
        if (this.config.tileHighlight() && (shape = npc.getCanvasTilePoly()) != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke((float)this.config.tileWidth()));
            graphics.draw(shape);
        }
        if (this.config.outlineHighlight()) {
            int outlineWidth = (int)this.config.outlineWidth();
            this.modelOutlineRenderer.drawOutline(npc, outlineWidth, color, this.config.outlineFeather());
        }
    }
}

