/*
 * Decompiled with CFR 0.152.
 */
package com.slayertaghighlight;

import com.slayertaghighlight.SlayerTagHighlightConfig;
import com.slayertaghighlight.SlayerTagHighlightPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class SlayerTagHighlightMinimapOverlay
extends Overlay {
    private Client client;
    private SlayerTagHighlightPlugin plugin;
    private SlayerTagHighlightConfig config;

    @Inject
    private SlayerTagHighlightMinimapOverlay(Client client, SlayerTagHighlightPlugin plugin, SlayerTagHighlightConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.minimapHighlight()) {
            return null;
        }
        for (NPC npc : this.plugin.getHighlights()) {
            Point minimapLocation = npc.getMinimapLocation();
            if (minimapLocation == null) continue;
            OverlayUtil.renderMinimapLocation((Graphics2D)graphics, (Point)minimapLocation, (Color)this.config.highlightColor());
        }
        return null;
    }
}

