/*
 * Decompiled with CFR 0.152.
 */
package bbp.trimmer;

import bbp.trimmer.ArmourTrimmerConfig;
import bbp.trimmer.configs.AbyssalWhipMode;
import bbp.trimmer.configs.DarkBowMode;
import bbp.trimmer.configs.GracefulMode;
import bbp.trimmer.configs.GraniteMaulMode;
import bbp.trimmer.configs.RuneArmourMode;
import bbp.trimmer.configs.RuneScimitarMode;
import com.google.common.collect.ImmutableMap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.AsyncBufferedImage;

public class ArmourTrimmerOverlay
extends WidgetItemOverlay {
    private final ItemManager itemManager;
    private final ArmourTrimmerConfig config;
    private static final Map<Integer, Integer[]> ITEM_REMAP = new ImmutableMap.Builder().put((Object)1155, (Object)new Integer[]{12221, 12211}).put((Object)1117, (Object)new Integer[]{12215, 12205}).put((Object)1075, (Object)new Integer[]{12217, 12207}).put((Object)1087, (Object)new Integer[]{12219, 12209}).put((Object)1189, (Object)new Integer[]{12223, 12213}).put((Object)1153, (Object)new Integer[]{12231, 12241}).put((Object)1115, (Object)new Integer[]{12225, 12235}).put((Object)1067, (Object)new Integer[]{12227, 12237}).put((Object)1081, (Object)new Integer[]{12229, 12239}).put((Object)1191, (Object)new Integer[]{12233, 12243}).put((Object)1157, (Object)new Integer[]{20193, 20178}).put((Object)1119, (Object)new Integer[]{20184, 20169}).put((Object)1069, (Object)new Integer[]{20187, 20172}).put((Object)1083, (Object)new Integer[]{20190, 20175}).put((Object)1193, (Object)new Integer[]{20196, 20181}).put((Object)1165, (Object)new Integer[]{2587, 2595}).put((Object)1125, (Object)new Integer[]{2583, 2591}).put((Object)1077, (Object)new Integer[]{2585, 2593}).put((Object)1089, (Object)new Integer[]{3472, 3473}).put((Object)1195, (Object)new Integer[]{2589, 2597}).put((Object)1159, (Object)new Integer[]{12293, 12283}).put((Object)1121, (Object)new Integer[]{12287, 12277}).put((Object)1071, (Object)new Integer[]{12289, 12279}).put((Object)1085, (Object)new Integer[]{12295, 12285}).put((Object)1197, (Object)new Integer[]{12291, 12281}).put((Object)1161, (Object)new Integer[]{2605, 2613}).put((Object)1123, (Object)new Integer[]{2599, 2607}).put((Object)1073, (Object)new Integer[]{2601, 2609}).put((Object)1091, (Object)new Integer[]{3474, 3475}).put((Object)1199, (Object)new Integer[]{2603, 2611}).put((Object)579, (Object)new Integer[]{7396, 7394}).put((Object)577, (Object)new Integer[]{7392, 7390}).put((Object)1011, (Object)new Integer[]{7388, 7386}).put((Object)1017, (Object)new Integer[]{12455, 12453}).put((Object)581, (Object)new Integer[]{12451, 12449}).put((Object)1015, (Object)new Integer[]{12447, 12445}).put((Object)1129, (Object)new Integer[]{null, 23381}).put((Object)1095, (Object)new Integer[]{null, 23384}).put((Object)1133, (Object)new Integer[]{7364, 7362}).put((Object)1097, (Object)new Integer[]{7368, 7366}).put((Object)1135, (Object)new Integer[]{7372, 7370}).put((Object)1099, (Object)new Integer[]{7380, 7378}).put((Object)2499, (Object)new Integer[]{7376, 7374}).put((Object)2493, (Object)new Integer[]{7384, 7382}).put((Object)2501, (Object)new Integer[]{12331, 12327}).put((Object)2495, (Object)new Integer[]{12333, 12329}).put((Object)2503, (Object)new Integer[]{12385, 12381}).put((Object)2497, (Object)new Integer[]{12387, 12383}).put((Object)544, (Object)new Integer[]{23303, 20199}).put((Object)542, (Object)new Integer[]{23306, 20202}).put((Object)3105, (Object)new Integer[]{null, 23413}).put((Object)1171, (Object)new Integer[]{null, 20166}).put((Object)6570, (Object)new Integer[]{null, 21295}).put((Object)11335, (Object)new Integer[]{null, 12417}).put((Object)2513, (Object)new Integer[]{null, 12414}).put((Object)21892, (Object)new Integer[]{null, 22242}).put((Object)4087, (Object)new Integer[]{null, 12415}).put((Object)4585, (Object)new Integer[]{null, 12416}).put((Object)1187, (Object)new Integer[]{null, 12418}).put((Object)21895, (Object)new Integer[]{null, 22244}).put((Object)4587, (Object)new Integer[]{null, 20000}).put((Object)12954, (Object)new Integer[]{null, 19722}).put((Object)11840, (Object)new Integer[]{null, 22234}).put((Object)11802, (Object)new Integer[]{null, 20368}).put((Object)11804, (Object)new Integer[]{null, 20370}).put((Object)11806, (Object)new Integer[]{null, 20372}).put((Object)11808, (Object)new Integer[]{null, 20374}).put((Object)6918, (Object)new Integer[]{12457, 12419}).put((Object)6916, (Object)new Integer[]{12458, 12420}).put((Object)6924, (Object)new Integer[]{12459, 12421}).put((Object)21018, (Object)new Integer[]{null, 24664}).put((Object)21021, (Object)new Integer[]{null, 24666}).put((Object)21024, (Object)new Integer[]{null, 24668}).put((Object)6528, (Object)new Integer[]{null, 23235}).put((Object)6585, (Object)new Integer[]{null, 12436}).put((Object)19553, (Object)new Integer[]{null, 20366}).put((Object)19547, (Object)new Integer[]{null, 22249}).put((Object)8850, (Object)new Integer[]{null, 23230}).put((Object)4131, (Object)new Integer[]{null, 12391}).build();
    private static final Map<Integer, Integer[]> GRACEFUL_REMAP = new ImmutableMap.Builder().put((Object)11850, (Object)new Integer[]{13579, 13591, 13603, 13615, 13627, 13667, 21061, 24743}).put((Object)11854, (Object)new Integer[]{13583, 13595, 13607, 13619, 13631, 13671, 21067, 24749}).put((Object)11856, (Object)new Integer[]{13585, 13597, 13609, 13621, 13633, 13673, 21070, 24752}).put((Object)11860, (Object)new Integer[]{13589, 13601, 13613, 13625, 13637, 13677, 21076, 24758}).put((Object)11852, (Object)new Integer[]{13581, 13593, 13605, 13617, 13629, 13669, 21064, 24746}).put((Object)11858, (Object)new Integer[]{13587, 13599, 13611, 13623, 13635, 13675, 21073, 24755}).build();
    private static final int[] DARK_BOW_REMAP = new int[]{12765, 12766, 12767, 12768};
    private static final int[] ABYSSAL_WHIP_REMAP = new int[]{12773, 12774, 12006};
    private static final Map<Integer, Integer[]> RUNE_ARMOUR_REMAP = new ImmutableMap.Builder().put((Object)1163, (Object)new Integer[]{2627, 2619, 3486, 12466, 12476, 12486, 2673, 2665, 2657}).put((Object)1127, (Object)new Integer[]{2623, 2615, 3481, 12460, 12470, 12480, 2669, 2661, 2653}).put((Object)1079, (Object)new Integer[]{2625, 2617, 3483, 12462, 12472, 12482, 2671, 2663, 2655}).put((Object)1093, (Object)new Integer[]{3477, 3476, 3485, 12464, 12474, 12484, 3480, 3479, 3478}).put((Object)1201, (Object)new Integer[]{2629, 2621, 3488, 12468, 12478, 12488, 2675, 2667, 2659}).build();
    private static final int[] GRANITE_MAUL_REMAP = new int[]{12848, 24225, 24227};
    private static final int[] RUNE_SCIMITAR_REMAP = new int[]{12389, 23330, 23332, 23334};

    @Inject
    private ArmourTrimmerOverlay(ItemManager itemManager, ArmourTrimmerConfig config) {
        this.itemManager = itemManager;
        this.config = config;
        this.showOnEquipment();
        this.showOnInventory();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        int idx = 1;
        AsyncBufferedImage replacement = null;
        if (ITEM_REMAP.containsKey(itemId)) {
            if (this.config.trimGold()) {
                replacement = this.itemManager.getImage(ITEM_REMAP.get(itemId)[idx].intValue());
            } else if (ITEM_REMAP.get(itemId)[0] != null) {
                idx = 0;
                replacement = this.itemManager.getImage(ITEM_REMAP.get(itemId)[idx].intValue());
            }
        } else if (GRACEFUL_REMAP.containsKey(itemId) && this.config.gracefulMode() != GracefulMode.NONE) {
            idx = this.config.gracefulMode().ordinal();
            replacement = this.itemManager.getImage(GRACEFUL_REMAP.get(itemId)[idx].intValue());
        } else if (itemId == 11235 && this.config.darkBowMode() != DarkBowMode.NONE) {
            idx = this.config.darkBowMode().ordinal();
            replacement = this.itemManager.getImage(DARK_BOW_REMAP[idx]);
        } else if (itemId == 4151 && this.config.abyssalWhipMode() != AbyssalWhipMode.NONE) {
            idx = this.config.abyssalWhipMode().ordinal();
            replacement = this.itemManager.getImage(ABYSSAL_WHIP_REMAP[idx]);
        } else if (RUNE_ARMOUR_REMAP.containsKey(itemId) && this.config.runeArmourMode() != RuneArmourMode.NONE) {
            idx = this.config.runeArmourMode().ordinal();
            replacement = this.itemManager.getImage(RUNE_ARMOUR_REMAP.get(itemId)[idx].intValue());
        } else if (itemId == 4153 && this.config.graniteMaulMode() != GraniteMaulMode.NONE) {
            idx = this.config.graniteMaulMode().ordinal();
            replacement = this.itemManager.getImage(GRANITE_MAUL_REMAP[idx]);
        } else if (itemId == 1333 && this.config.runeScimitarMode() != RuneScimitarMode.NONE) {
            idx = this.config.runeScimitarMode().ordinal();
            replacement = this.itemManager.getImage(RUNE_SCIMITAR_REMAP[idx]);
        }
        if (replacement != null) {
            Rectangle bounds = itemWidget.getCanvasBounds();
            graphics.drawImage((Image)replacement, (int)bounds.getX(), (int)bounds.getY(), null);
        }
    }
}

