/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor;

import java.util.Random;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuckPond {
    private static final Logger log = LoggerFactory.getLogger(DuckPond.class);
    private WorldPoint NWTile;
    private WorldPoint SETile;
    private WorldPoint SWTile;
    private int maxDucks;
    private int plane;

    DuckPond(WorldPoint nwtile, WorldPoint setile, int maxDucks) {
        this.NWTile = nwtile;
        this.SETile = setile;
        this.maxDucks = maxDucks;
        this.plane = nwtile.getPlane();
        this.SWTile = new WorldPoint(nwtile.getX(), setile.getY(), this.plane);
    }

    public WorldPoint getRandomPointInPond() {
        int maxX = Math.max(this.NWTile.getX(), this.SETile.getX()) + 1;
        int minX = Math.min(this.NWTile.getX(), this.SETile.getX());
        int maxY = Math.max(this.NWTile.getY(), this.SETile.getY()) + 1;
        int minY = Math.min(this.NWTile.getY(), this.SETile.getY());
        return new WorldPoint(this.getRandom(minX, maxX), this.getRandom(minY, maxY), this.getPlane());
    }

    public int getPlane() {
        return this.plane;
    }

    public int getMaxDucks() {
        return this.maxDucks;
    }

    public int getRandom(int min, int max) {
        Random random = new Random();
        return random.nextInt(max - min) + min;
    }

    public boolean compareSWTiles(WorldPoint comparisionPondSWTile) {
        return comparisionPondSWTile.distanceTo(this.SWTile) == 0;
    }
}

