/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor;

import com.skeldoor.Duck;
import com.skeldoor.DuckOverlay;
import com.skeldoor.DuckPond;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.MenuAction;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Duck Duck Goose", description="Adds ducks to empty ponds to help bring life to the world")
public class DuckPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DuckPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    ChatMessageManager chatMessageManager;
    @Inject
    private DuckOverlay duckOverlay;
    List<Duck> ducks;
    DuckPond yanillePond = new DuckPond(new WorldPoint(2542, 3082, 0), new WorldPoint(2544, 3079, 0), 3);
    DuckPond barbVillagePond = new DuckPond(new WorldPoint(3110, 3435, 0), new WorldPoint(3113, 3431, 0), 4);
    DuckPond zulandraFishingPond = new DuckPond(new WorldPoint(2184, 3076, 0), new WorldPoint(2195, 3071, 0), 5);
    DuckPond zulandraPierPond = new DuckPond(new WorldPoint(2217, 3052, 0), new WorldPoint(2210, 3055, 0), 3);
    DuckPond undergroundBloodveldPond = new DuckPond(new WorldPoint(3618, 9742, 0), new WorldPoint(3624, 9736, 0), 2);
    DuckPond southFarmingGuildPond = new DuckPond(new WorldPoint(1235, 3690, 0), new WorldPoint(1226, 3693, 0), 5);
    DuckPond fossilIslandCleaningPond = new DuckPond(new WorldPoint(3691, 3884, 0), new WorldPoint(3692, 3882, 0), 2);
    DuckPond lletyaPond = new DuckPond(new WorldPoint(2325, 3152, 0), new WorldPoint(2328, 3151, 0), 3);
    DuckPond[] staticDuckPonds = new DuckPond[]{this.yanillePond, this.barbVillagePond, this.zulandraFishingPond, this.zulandraPierPond, this.undergroundBloodveldPond, this.southFarmingGuildPond, this.fossilIslandCleaningPond, this.lletyaPond};
    List<DuckPond> dynamicDuckPonds;
    int breadItemId = 2309;
    int POHPondID = 4527;
    boolean ducksInitialised = false;

    protected void startUp() {
        this.ducks = new ArrayList<Duck>();
        this.dynamicDuckPonds = new ArrayList<DuckPond>();
        this.overlayManager.add((Overlay)this.duckOverlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.duckOverlay);
        for (Duck duck : this.ducks) {
            duck.despawn();
        }
    }

    public Client getClient() {
        return this.client;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGING_IN && !this.ducksInitialised) {
            for (DuckPond duckpond : this.staticDuckPonds) {
                for (int i = 0; i < duckpond.getMaxDucks(); ++i) {
                    Duck duck = new Duck();
                    this.ducks.add(duck);
                    duck.init(this.client, duckpond);
                }
            }
            this.ducksInitialised = true;
        }
        if (gameStateChanged.getGameState() == GameState.LOADING || gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            for (Duck duck : this.ducks) {
                duck.despawn();
            }
        }
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            for (Duck duck : this.ducks) {
                duck.spawn(duck.pond.getRandomPointInPond(), this.getRandom(0, 2047));
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned gos) {
        GameObject housePond = gos.getGameObject();
        if (housePond.getId() == this.POHPondID) {
            if (!this.dynamicPondAlreadyExists(housePond)) {
                WorldPoint SWTile = housePond.getWorldLocation();
                DuckPond dynamicHousePond = new DuckPond(new WorldPoint(SWTile.getX(), SWTile.getY() + 1, SWTile.getPlane()), new WorldPoint(SWTile.getX() + 1, SWTile.getY(), SWTile.getPlane()), 2);
                this.dynamicDuckPonds.add(dynamicHousePond);
                for (int i = 0; i < dynamicHousePond.getMaxDucks(); ++i) {
                    Duck duck = new Duck();
                    this.ducks.add(duck);
                    duck.init(this.client, dynamicHousePond);
                    duck.getRlObject().setRadius(250);
                }
            }
            for (Duck duck : this.ducks) {
                duck.despawn();
                duck.spawn(duck.pond.getRandomPointInPond(), this.getRandom(0, 2047));
            }
        }
    }

    private boolean dynamicPondAlreadyExists(GameObject housePond) {
        WorldPoint SWTile = housePond.getWorldLocation();
        for (DuckPond existingDynamicDuckPond : this.dynamicDuckPonds) {
            if (!existingDynamicDuckPond.compareSWTiles(SWTile)) continue;
            return true;
        }
        return false;
    }

    @Schedule(period=10L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void waddleToNewPoint() {
        for (Duck duck : this.ducks) {
            if (!duck.isActive() || this.getRandom(0, 3) != 0) continue;
            WorldPoint newPoint = duck.pond.getRandomPointInPond();
            duck.moveTo(newPoint, DuckPlugin.radToJau(Math.atan2(newPoint.getX(), newPoint.getY())));
            duck.quack();
        }
    }

    @Schedule(period=5L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void quack() {
        for (Duck duck : this.ducks) {
            if (!duck.isActive() || this.getRandom(0, 3) != 0) continue;
            duck.quack();
        }
    }

    static int radToJau(double a) {
        int j = (int)Math.round(a / 0.0030679615757712823);
        return j & 0x7FF;
    }

    @Subscribe
    public void onClientTick(ClientTick ignored) {
        for (Duck duck : this.ducks) {
            if (duck.getRlObject() == null || duck.animationPoses == null) continue;
            duck.onClientTick();
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened ignored) {
        int firstMenuIndex = 1;
        for (Duck duck : this.ducks) {
            if (!duck.isActive() || !duck.getClickbox().contains((double)this.client.getMouseCanvasPosition().getX(), (double)this.client.getMouseCanvasPosition().getY())) continue;
            String option = Objects.requireNonNull(this.client.getItemContainer(InventoryID.INVENTORY)).contains(this.breadItemId) ? "Feed" : "Examine";
            this.client.createMenuEntry(firstMenuIndex).setOption(option).setTarget("<col=fffe00>" + duck.getDuckName() + "</col>").setType(MenuAction.RUNELITE).setParam0(0).setParam1(0).setDeprioritized(true);
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuOption().equals("Feed") || event.getMenuOption().equals("Examine")) {
            if (!event.getMenuTarget().equals("<col=fffe00>Duck</col>") && !event.getMenuTarget().equals("<col=fffe00>Drake</col>")) {
                return;
            }
            event.consume();
            String messageText = Objects.equals(event.getMenuOption(), "Feed") ? "You tear off a chunk of bread and offer it to the duck. They take it enthusiastically and quack." : this.ducks.get(1).getExamine(event.getMenuTarget());
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(messageText).build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.NPC_EXAMINE).runeLiteFormattedMessage(chatMessage).timestamp((int)(System.currentTimeMillis() / 1000L)).build());
        }
    }

    public int getRandom(int min, int max) {
        Random random = new Random();
        return random.nextInt(max - min) + min;
    }
}

