/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor;

import com.skeldoor.Duck;
import com.skeldoor.DuckPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class DuckOverlay
extends Overlay {
    public static final int IMAGE_Z_OFFSET = 30;
    private final DuckPlugin plugin;

    @Inject
    public DuckOverlay(DuckPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        for (Duck duck : this.plugin.ducks) {
            Point p;
            LocalPoint lp;
            if (!duck.isActive() || !duck.getQuacking() || (lp = duck.getLocalLocation()) == null || (p = Perspective.localToCanvas((Client)this.plugin.getClient(), (LocalPoint)lp, (int)this.plugin.getClient().getPlane(), (int)duck.getRlObject().getModelHeight())) == null) continue;
            Font overheadFont = FontManager.getRunescapeBoldFont();
            FontMetrics metrics = graphics.getFontMetrics(overheadFont);
            Point shiftedP = new Point(p.getX() - metrics.stringWidth(duck.getQuackText()) / 2, p.getY());
            graphics.setFont(overheadFont);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)shiftedP, (String)duck.getQuackText(), (Color)JagexColors.YELLOW_INTERFACE_TEXT);
        }
        return null;
    }
}

