/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor;

import com.skeldoor.DuckPond;
import java.util.Random;
import net.runelite.api.AABB;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.Perspective;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.geometry.SimplePolygon;
import net.runelite.api.model.Jarvis;

public class Duck {
    private Client client;
    private RuneLiteObject rlObject;
    DuckPond pond;
    private int cTargetIndex;
    private final int MAX_TARGET_QUEUE_SIZE = 10;
    private final Target[] targetQueue = new Target[10];
    private int targetQueueSize;
    private int lastDistance;
    int currentAnimationID = 6818;
    int currentMovementSpeed = 0;
    int duckIdleAnimationId = 6818;
    int duckMovingAnimationId = 6817;
    public Animation[] animationPoses = new Animation[2];
    private final int[] duckModelIds = new int[]{26873, 26870};
    private final String[] duckNames = new String[]{"Drake", "Duck"};
    private String duckName;
    private boolean quacking = false;
    private int quackTimer = 0;
    private final int MAX_QUACK_TIME = 30;
    private final String quackText = "Quack!";
    SimplePolygon clickbox;

    public void init(Client client, DuckPond pond) {
        this.client = client;
        this.rlObject = client.createRuneLiteObject();
        this.pond = pond;
        this.animationPoses[POSE_ANIM.IDLE.ordinal()] = client.loadAnimation(this.duckIdleAnimationId);
        this.animationPoses[POSE_ANIM.WALK.ordinal()] = client.loadAnimation(this.duckMovingAnimationId);
        this.assignDuckSex();
        for (int i = 0; i < 10; ++i) {
            this.targetQueue[i] = new Target();
        }
    }

    private void assignDuckSex() {
        int random = this.getRandom(0, 4);
        if (random == 0) {
            this.setModel(this.client.loadModel(this.duckModelIds[0]));
            this.duckName = this.duckNames[0];
        } else {
            this.setModel(this.client.loadModel(this.duckModelIds[1]));
            this.duckName = this.duckNames[1];
        }
    }

    public void setModel(Model model) {
        this.rlObject.setModel(model);
    }

    public RuneLiteObject getRlObject() {
        return this.rlObject;
    }

    public String getDuckName() {
        return this.duckName;
    }

    public void spawn(WorldPoint position, int jauOrientation) {
        LocalPoint localPosition = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.pond.getRandomPointInPond());
        if (localPosition == null || this.client.getPlane() != position.getPlane()) {
            return;
        }
        this.rlObject.setLocation(localPosition, position.getPlane());
        this.rlObject.setOrientation(jauOrientation);
        this.rlObject.setAnimation(this.animationPoses[0]);
        this.rlObject.setShouldLoop(true);
        this.rlObject.setActive(true);
        this.currentAnimationID = this.duckIdleAnimationId;
        this.currentMovementSpeed = 0;
        this.targetQueueSize = 0;
    }

    public void despawn() {
        this.rlObject.setActive(false);
        this.currentAnimationID = -1;
        this.currentMovementSpeed = 0;
        this.targetQueueSize = 0;
    }

    public LocalPoint getLocalLocation() {
        return this.rlObject.getLocation();
    }

    public boolean isActive() {
        return this.rlObject.isActive();
    }

    public int getOrientation() {
        return this.rlObject.getOrientation();
    }

    public SimplePolygon getClickbox() {
        return this.clickbox;
    }

    public boolean getQuacking() {
        return this.quacking;
    }

    public String getQuackText() {
        return "Quack!";
    }

    public void quack() {
        this.quacking = true;
        this.quackTimer = 30;
    }

    public String getExamine(String menuTarget) {
        String duckExamine;
        String[] duckExamines = new String[]{"Quack?", "It walks like a duck. Well, I guess it waddles like one."};
        String rareDrakeExamine = "This isn't Josh?";
        if (menuTarget.contains("Drake")) {
            duckExamine = duckExamines[0];
            if (this.getRandom(0, 50) == 0) {
                duckExamine = rareDrakeExamine;
            }
        } else {
            duckExamine = duckExamines[1];
        }
        return duckExamine;
    }

    public void moveTo(WorldPoint worldPosition, int jauOrientation) {
        if (!this.rlObject.isActive()) {
            this.spawn(worldPosition, jauOrientation);
        }
        LocalPoint localPosition = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPosition);
        if (this.targetQueueSize >= 8) {
            this.targetQueueSize = 0;
        }
        int prevTargetIndex = (this.cTargetIndex + this.targetQueueSize - 1) % 10;
        int newTargetIndex = (this.cTargetIndex + this.targetQueueSize) % 10;
        if (localPosition == null) {
            return;
        }
        WorldPoint prevWorldPosition = this.targetQueueSize++ > 0 ? this.targetQueue[prevTargetIndex].worldDestinationPosition : WorldPoint.fromLocal((Client)this.client, (LocalPoint)this.rlObject.getLocation());
        int distance = prevWorldPosition.distanceTo(worldPosition);
        this.targetQueue[newTargetIndex].worldDestinationPosition = worldPosition;
        this.targetQueue[newTargetIndex].localDestinationPosition = localPosition;
        this.targetQueue[newTargetIndex].currentDistance = distance;
    }

    public void onClientTick() {
        if (this.quackTimer > 0) {
            --this.quackTimer;
        }
        if (this.quackTimer == 0) {
            this.quacking = false;
        }
        if (this.rlObject.isActive()) {
            if (this.targetQueueSize > 0) {
                if (this.targetQueue[this.cTargetIndex] == null || this.targetQueue[this.cTargetIndex].worldDestinationPosition == null) {
                    return;
                }
                int targetPlane = this.targetQueue[this.cTargetIndex].worldDestinationPosition.getPlane();
                LocalPoint targetPosition = this.targetQueue[this.cTargetIndex].localDestinationPosition;
                if (targetPosition == null) {
                    this.despawn();
                    return;
                }
                double intx = this.rlObject.getLocation().getX() - targetPosition.getX();
                double inty = this.rlObject.getLocation().getY() - targetPosition.getY();
                boolean rotationDone = this.rotateObject(intx, inty);
                if (this.client.getPlane() != targetPlane || !targetPosition.isInScene()) {
                    this.despawn();
                    return;
                }
                if (this.lastDistance != this.targetQueue[this.cTargetIndex].currentDistance) {
                    int distance = this.targetQueue[this.cTargetIndex].currentDistance;
                    this.rlObject.setAnimation(distance > 1 ? null : this.animationPoses[distance]);
                    if (this.rlObject.getAnimation() == null) {
                        this.rlObject.setAnimation(this.animationPoses[1]);
                    }
                }
                this.lastDistance = this.targetQueue[this.cTargetIndex].currentDistance;
                LocalPoint currentPosition = this.rlObject.getLocation();
                int dx = targetPosition.getX() - currentPosition.getX();
                int dy = targetPosition.getY() - currentPosition.getY();
                if (dx != 0 || dy != 0) {
                    int speed = 2;
                    if (Math.abs(dx) > speed) {
                        dx = Integer.signum(dx) * speed;
                    }
                    if (Math.abs(dy) > speed) {
                        dy = Integer.signum(dy) * speed;
                    }
                    LocalPoint newLocation = new LocalPoint(currentPosition.getX() + dx, currentPosition.getY() + dy);
                    this.rlObject.setLocation(newLocation, targetPlane);
                    dx = targetPosition.getX() - this.rlObject.getLocation().getX();
                    dy = targetPosition.getY() - this.rlObject.getLocation().getY();
                }
                if (dx == 0 && dy == 0 && rotationDone) {
                    this.cTargetIndex = (this.cTargetIndex + 1) % 10;
                    --this.targetQueueSize;
                    this.rlObject.setAnimation(this.animationPoses[0]);
                }
            }
            LocalPoint lp = this.getLocalLocation();
            int zOff = Perspective.getTileHeight((Client)this.client, (LocalPoint)lp, (int)this.client.getPlane());
            this.clickbox = Duck.calculateAABB(this.client, this.getRlObject().getModel(), this.getOrientation(), lp.getX(), lp.getY(), this.client.getPlane(), zOff);
        }
    }

    public boolean rotateObject(double intx, double inty) {
        int currentOrientation;
        int JAU_FULL_ROTATION = 2048;
        int targetOrientation = Duck.radToJau(Math.atan2(intx, inty));
        int dJau = (targetOrientation - (currentOrientation = this.rlObject.getOrientation())) % 2048;
        if (dJau != 0) {
            int JAU_HALF_ROTATION = 1024;
            int JAU_TURN_SPEED = 32;
            int dJauCW = Math.abs(dJau);
            if (dJauCW > 1024) {
                dJau = (currentOrientation - targetOrientation) % 2048;
            } else if (dJauCW == 1024) {
                dJau = dJauCW;
            }
            if (Math.abs(dJau) > 32) {
                dJau = Integer.signum(dJau) * 32;
            }
            int newOrientation = (2048 + this.rlObject.getOrientation() + dJau) % 2048;
            this.rlObject.setOrientation(newOrientation);
            dJau = (targetOrientation - newOrientation) % 2048;
        }
        return dJau == 0;
    }

    static int radToJau(double a) {
        int j = (int)Math.round(a / 0.0030679615757712823);
        return j & 0x7FF;
    }

    public int getRandom(int min, int max) {
        Random random = new Random();
        return random.nextInt(max - min) + min;
    }

    private static SimplePolygon calculateAABB(Client client, Model m, int jauOrient, int x, int y, int z, int zOff) {
        AABB aabb = m.getAABB(jauOrient);
        int x1 = aabb.getCenterX();
        int y1 = aabb.getCenterZ();
        int z1 = aabb.getCenterY() + zOff;
        int ex = aabb.getExtremeX();
        int ey = aabb.getExtremeZ();
        int ez = aabb.getExtremeY();
        int x2 = x1 + ex;
        int y2 = y1 + ey;
        int z2 = z1 + ez;
        int[] xa = new int[]{x1 -= ex, x2, x1, x2, x1, x2, x1, x2};
        int[] ya = new int[]{y1 -= ey, y1, y2, y2, y1, y1, y2, y2};
        int[] za = new int[]{z1 -= ez, z1, z1, z1, z2, z2, z2, z2};
        int[] x2d = new int[8];
        int[] y2d = new int[8];
        Duck.modelToCanvasCpu(client, 8, x, y, z, 0, xa, ya, za, x2d, y2d);
        return Jarvis.convexHull((int[])x2d, (int[])y2d);
    }

    private static void modelToCanvasCpu(Client client, int end, int x3dCenter, int y3dCenter, int z3dCenter, int rotate, int[] x3d, int[] y3d, int[] z3d, int[] x2d, int[] y2d) {
        int cameraPitch = client.getCameraPitch();
        int cameraYaw = client.getCameraYaw();
        int pitchSin = Perspective.SINE[cameraPitch];
        int pitchCos = Perspective.COSINE[cameraPitch];
        int yawSin = Perspective.SINE[cameraYaw];
        int yawCos = Perspective.COSINE[cameraYaw];
        int rotateSin = Perspective.SINE[rotate];
        int rotateCos = Perspective.COSINE[rotate];
        int cx = x3dCenter - client.getCameraX();
        int cy = y3dCenter - client.getCameraY();
        int cz = z3dCenter - client.getCameraZ();
        int viewportXMiddle = client.getViewportWidth() / 2;
        int viewportYMiddle = client.getViewportHeight() / 2;
        int viewportXOffset = client.getViewportXOffset();
        int viewportYOffset = client.getViewportYOffset();
        int zoom3d = client.getScale();
        for (int i = 0; i < end; ++i) {
            int viewY;
            int viewX;
            int x = x3d[i];
            int y = y3d[i];
            int z = z3d[i];
            if (rotate != 0) {
                int x0 = x;
                x = x0 * rotateCos + y * rotateSin >> 16;
                y = y * rotateCos - x0 * rotateSin >> 16;
            }
            int x1 = (x += cx) * yawCos + (y += cy) * yawSin >> 16;
            int y1 = y * yawCos - x * yawSin >> 16;
            int y2 = (z += cz) * pitchCos - y1 * pitchSin >> 16;
            int z1 = y1 * pitchCos + z * pitchSin >> 16;
            if (z1 < 50) {
                viewX = Integer.MIN_VALUE;
                viewY = Integer.MIN_VALUE;
            } else {
                viewX = viewportXMiddle + x1 * zoom3d / z1 + viewportXOffset;
                viewY = viewportYMiddle + y2 * zoom3d / z1 + viewportYOffset;
            }
            x2d[i] = viewX;
            y2d[i] = viewY;
        }
    }

    private class Target {
        public WorldPoint worldDestinationPosition;
        public LocalPoint localDestinationPosition;
        public int currentDistance;

        private Target() {
        }
    }

    private static enum POSE_ANIM {
        IDLE,
        WALK;

    }
}

