/*
 * Decompiled with CFR 0.152.
 */
package com.templetracker.overlay;

import com.templetracker.constructors.TempleTracker;
import com.templetracker.overlay.TempleTrackerPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class TreksPerHourOverlayPanel
extends OverlayPanel {
    private ArrayList<TempleTracker> TTList = new ArrayList();
    private long meanTime;
    private int meanPoints;
    public static final String TREKS_RESET = "Reset";

    @Inject
    private TreksPerHourOverlayPanel(TempleTrackerPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, TREKS_RESET, "Treks per hour"));
    }

    private void addSplitPanel(String first, String second) {
        LineComponent splitComponent = LineComponent.builder().left(first).right(second).build();
        this.panelComponent.getChildren().add(splitComponent);
    }

    private void addSpacer(final int height) {
        LayoutableRenderableEntity spacer = new LayoutableRenderableEntity(){

            public Rectangle getBounds() {
                return new Rectangle(5, height);
            }

            public void setPreferredLocation(Point position) {
            }

            public void setPreferredSize(Dimension dimension) {
            }

            public Dimension render(Graphics2D graphics) {
                return new Dimension(5, height);
            }
        };
        this.panelComponent.getChildren().add(spacer);
    }

    public void reset() {
        this.TTList = new ArrayList();
        this.meanTime = 0L;
        this.meanPoints = 0;
    }

    public void addTrek(TempleTracker tracker) {
        this.TTList.add(tracker);
        ArrayList tempTTList = this.TTList.stream().filter(TT -> TT.getRoute() == tracker.getRoute() && TT.getEndTime() > 0L).collect(Collectors.toCollection(ArrayList::new));
        if (tempTTList.size() > 1) {
            long tempAddTimes = 0L;
            int tempAddPoints = ((TempleTracker)tempTTList.get(0)).getPoints();
            for (int i = 1; i < tempTTList.size(); ++i) {
                tempAddTimes += ((TempleTracker)tempTTList.get(i)).getEndTime() - ((TempleTracker)tempTTList.get(i - 1)).getEndTime();
                tempAddPoints += ((TempleTracker)tempTTList.get(i)).getPoints();
            }
            this.meanTime = tempAddTimes / (long)(tempTTList.size() - 1);
            this.meanPoints = tempAddPoints / tempTTList.size();
        } else if (tempTTList.size() == 1 && this.TTList.size() >= 2) {
            this.meanTime = this.TTList.get(this.TTList.size() - 1).getEndTime() - this.TTList.get(this.TTList.size() - 2).getEndTime();
            this.meanPoints = this.TTList.get(this.TTList.size() - 1).getPoints();
        } else {
            this.meanTime = 0L;
        }
    }

    public Dimension render(Graphics2D graphics) {
        if (this.meanTime > 0L) {
            this.panelComponent.getChildren().clear();
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Treks/Hour").build());
            this.addSpacer(3);
            this.addSplitPanel("Route " + this.TTList.get(this.TTList.size() - 1).getRoute() + ":", String.format("%.1f", 3600000.0 / (double)this.meanTime));
            this.addSpacer(2);
            this.addSplitPanel("Avg Points:", Integer.toString(this.meanPoints));
        }
        return super.render(graphics);
    }

    private static String millisToMinuteString(long time) {
        long minutes = time / 1000L / 60L;
        long seconds = time / 1000L % 60L;
        return minutes + ":" + (seconds < 10L ? "0" : "") + seconds;
    }
}

