/*
 * Decompiled with CFR 0.152.
 */
package com.templetracker.overlay;

import com.google.inject.Provides;
import com.templetracker.FileReadWriter;
import com.templetracker.constructors.Companion;
import com.templetracker.constructors.Encounter;
import com.templetracker.constructors.EncounterName;
import com.templetracker.constructors.StartLocation;
import com.templetracker.constructors.TempleTracker;
import com.templetracker.overlay.TempleTrackerConfig;
import com.templetracker.overlay.TempleTrackerOverlayPanel;
import com.templetracker.overlay.TreksPerHourOverlayPanel;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Temple Tracker", description="Adds an overlay to the screen showing treks/hour, duration of each trek and average points")
public class TempleTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TempleTrackerPlugin.class);
    TempleTracker tracker = new TempleTracker();
    @Inject
    private Client client;
    @Inject
    private TempleTrackerConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TempleTrackerOverlayPanel overlayPanel;
    @Inject
    TreksPerHourOverlayPanel treksPerHourOverlayPanel;
    private final FileReadWriter fw = new FileReadWriter();
    private int previousRegion = 0;

    protected void startUp() {
    }

    protected void shutDown() {
        this.removePanels();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        if (this.tracker.getRoute() > 0) {
            return;
        }
        int ROUTE_1 = 21561365;
        int ROUTE_2 = 21561369;
        int ROUTE_3 = 21561373;
        switch (menuOptionClicked.getWidgetId()) {
            case 21561365: {
                this.tracker.setRoute(1);
                break;
            }
            case 21561369: {
                this.tracker.setRoute(2);
                break;
            }
            case 21561373: {
                this.tracker.setRoute(3);
                break;
            }
        }
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned groundObjectSpawned) {
        if (!this.tracker.isTempleTrekking()) {
            return;
        }
        int BOG = 13838;
        int BRIDGE = 13834;
        switch (groundObjectSpawned.getGroundObject().getId()) {
            case 13838: {
                this.newEncounter(EncounterName.BOG);
                break;
            }
            case 13834: {
                this.newEncounter(EncounterName.BRIDGE);
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned gameObjectSpawned) {
        if (!this.tracker.isTempleTrekking() || this.tracker.getLatestEncounter() != null && this.tracker.getLatestEncounter().getName() != null) {
            return;
        }
        int RIVER_SWING = 13847;
        int KRAKEN_BOAT = 13864;
        switch (gameObjectSpawned.getGameObject().getId()) {
            case 13847: {
                this.newEncounter(EncounterName.RIVER);
                break;
            }
            case 13864: {
                this.newEncounter(EncounterName.TENTACLES);
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        if (!this.tracker.isTempleTrekking() || npcSpawned == null || npcSpawned.getNpc() == null || npcSpawned.getNpc().getName() == null || this.tracker.getLatestEncounter() != null && this.tracker.getLatestEncounter().getName() != null) {
            return;
        }
        if (this.tracker.getCompanion() == null && Companion.getCompanion(npcSpawned.getNpc().getName()) != null) {
            this.tracker.setCompanion(Companion.getCompanion(npcSpawned.getNpc().getName()));
        }
        String GHAST_NAME = "Ghast";
        String SHADE_NAME = "Shade";
        String SHADE_RIYL_NAME = "Riyl shadow";
        String SHADE_ASYN_NAME = "Asyn shadow";
        String NAIL_BEAST_NAME = "Nail beast";
        String SNAIL_NAME = "Giant snail";
        String SNAKE_NAME = "Swamp snake";
        String VAMPYRE_NAME = "Vampyre Juvinate";
        String ABIDOR_NAME = "Abidor Crank";
        switch (npcSpawned.getNpc().getName()) {
            case "Ghast": {
                this.newEncounter(EncounterName.GHASTS);
                break;
            }
            case "Shade": 
            case "Asyn shadow": 
            case "Riyl shadow": {
                this.newEncounter(EncounterName.SHADES);
                break;
            }
            case "Nail beast": {
                this.newEncounter(EncounterName.NAIL_BEASTS);
                break;
            }
            case "Giant snail": {
                this.newEncounter(EncounterName.SNAILS);
                break;
            }
            case "Swamp snake": {
                this.newEncounter(EncounterName.SNAKES);
                break;
            }
            case "Vampyre Juvinate": {
                this.newEncounter(EncounterName.VAMPYRES);
                break;
            }
            case "Abidor Crank": {
                this.newEncounter(EncounterName.ABIDOR);
                break;
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        int points = this.client.getVarbitValue(1955);
        int startCheckValue = this.client.getVarbitValue(1956);
        int encounter = this.client.getVarbitValue(1958);
        int escaping = this.client.getVarbitValue(1954);
        if (points != this.tracker.getPoints() && points > this.tracker.getPoints() && this.tracker.isTempleTrekking()) {
            this.tracker.setPoints(points);
        }
        if (startCheckValue == 1 && this.tracker.getCheck() == 0) {
            this.tracker.setCheck(1);
        }
        if (encounter != 0 && this.tracker.getLatestEncounter() != null) {
            this.tracker.getLatestEncounter().setLocation(encounter);
        } else if (encounter == 0 && this.tracker.getLatestEncounter() != null) {
            this.tracker.getLatestEncounter().setEndTime(System.currentTimeMillis());
            this.tracker.addEncounterToList();
        }
        if (escaping == 0 && this.tracker.isTempleTrekking()) {
            this.templeTrekkingEnded();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGING_IN) {
            this.fw.updateUsername(this.client.getUsername());
        }
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        if (this.tracker.isTempleTrekking() && (this.client.getLocalPlayer().getWorldLocation().getRegionID() == StartLocation.BURGH_DE_ROTT.getRegionID() || this.client.getLocalPlayer().getWorldLocation().getRegionID() == StartLocation.PATERDOMUS.getRegionID())) {
            if (this.tracker.getEndTime() < 0L && this.tracker.getStartLocation() != null && this.client.getLocalPlayer().getWorldLocation().getRegionID() != this.tracker.getStartLocation().getRegionID()) {
                this.tracker.setEndTime(System.currentTimeMillis());
            }
            this.templeTrekkingEnded();
        }
        if (!(this.tracker.isTempleTrekking() || this.tracker.getCheck() != 1 || this.client.getLocalPlayer().getWorldLocation().getRegionID() != StartLocation.BURGH_DE_ROTT.getRegionID() && this.client.getLocalPlayer().getWorldLocation().getRegionID() != StartLocation.PATERDOMUS.getRegionID())) {
            this.templeTrekkingStarted();
        }
        int location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
        if (this.tracker.getEndTime() > 0L && location != StartLocation.BURGH_DE_ROTT.getRegionID() && location != StartLocation.PATERDOMUS.getRegionID() && location != 7769 && this.previousRegion != 7769 && location != 13613) {
            this.removePanels();
        }
        if (location != this.previousRegion) {
            this.previousRegion = location;
        }
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked overlayMenuClicked) {
        OverlayMenuEntry overlayMenuEntry = overlayMenuClicked.getEntry();
        if (overlayMenuEntry.getMenuAction() == MenuAction.RUNELITE_OVERLAY && overlayMenuClicked.getEntry().getOption().equals("Reset") && overlayMenuClicked.getOverlay() == this.treksPerHourOverlayPanel) {
            this.treksPerHourOverlayPanel.reset();
        }
    }

    public void newEncounter(EncounterName name) {
        if (this.tracker.getLatestEncounter() != null) {
            return;
        }
        Encounter tempEncounter = new Encounter();
        tempEncounter.setName(name);
        tempEncounter.setRoute(this.tracker.getRoute());
        this.tracker.setLatestEncounter(tempEncounter);
    }

    private void templeTrekkingStarted() {
        this.tracker = new TempleTracker();
        this.tracker.setTempleTrekking(true);
        if (this.client.getLocalPlayer() != null) {
            if (this.client.getLocalPlayer().getWorldLocation().getRegionID() == StartLocation.PATERDOMUS.getRegionID()) {
                this.tracker.setStartLocation(StartLocation.PATERDOMUS);
            } else if (this.client.getLocalPlayer().getWorldLocation().getRegionID() == StartLocation.BURGH_DE_ROTT.getRegionID()) {
                this.tracker.setStartLocation(StartLocation.BURGH_DE_ROTT);
            }
        }
        if (this.config.showOverlay()) {
            this.addPanels();
        }
    }

    private void templeTrekkingEnded() {
        this.tracker.setCheck(0);
        this.tracker.setTempleTrekking(false);
        if (this.tracker.getEndTime() < 0L) {
            this.overlayManager.remove((Overlay)this.overlayPanel);
        } else {
            if (this.config.logData()) {
                this.fw.writeToFile(this.tracker);
            }
            this.treksPerHourOverlayPanel.addTrek(this.tracker);
        }
    }

    private void addPanels() {
        this.overlayManager.add((Overlay)this.overlayPanel);
        this.overlayManager.add((Overlay)this.treksPerHourOverlayPanel);
    }

    private void removePanels() {
        this.overlayManager.remove((Overlay)this.overlayPanel);
        this.overlayManager.remove((Overlay)this.treksPerHourOverlayPanel);
    }

    @Provides
    TempleTrackerConfig provideConfig(ConfigManager configManager) {
        return (TempleTrackerConfig)configManager.getConfig(TempleTrackerConfig.class);
    }

    public TempleTracker getTracker() {
        return this.tracker;
    }
}

