/*
 * Decompiled with CFR 0.152.
 */
package com.templetracker.overlay;

import com.templetracker.constructors.Encounter;
import com.templetracker.constructors.TempleTracker;
import com.templetracker.overlay.TempleTrackerPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class TempleTrackerOverlayPanel
extends OverlayPanel {
    private final TempleTrackerPlugin plugin;

    @Inject
    private TempleTrackerOverlayPanel(TempleTrackerPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    private void addSplitPanel(String first, String second) {
        LineComponent splitComponent = LineComponent.builder().left(first).right(second).build();
        this.panelComponent.getChildren().add(splitComponent);
    }

    private void addSpacer(final int height) {
        LayoutableRenderableEntity spacer = new LayoutableRenderableEntity(){

            public Rectangle getBounds() {
                return new Rectangle(5, height);
            }

            public void setPreferredLocation(Point position) {
            }

            public void setPreferredSize(Dimension dimension) {
            }

            public Dimension render(Graphics2D graphics) {
                return new Dimension(5, height);
            }
        };
        this.panelComponent.getChildren().add(spacer);
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        TempleTracker tracker = this.plugin.getTracker();
        if (tracker.getRoute() > 0) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Route " + tracker.getRoute()).build());
            this.addSpacer(3);
        }
        this.addSplitPanel("Current Points:", Integer.toString(Math.max(tracker.getPoints(), 0)));
        this.addSpacer(3);
        long endTime = tracker.getEndTime() > 0L ? tracker.getEndTime() : System.currentTimeMillis();
        this.addSplitPanel("Duration:", TempleTrackerOverlayPanel.millisToMinuteString(endTime - tracker.getStartTime()));
        if (tracker.getLatestEncounter() != null || tracker.getEncounterList().size() > 0) {
            this.addSpacer(3);
            this.panelComponent.getChildren().add(LineComponent.builder().left("Encounters:").build());
            this.addSpacer(1);
            for (Encounter encounter : tracker.getEncounterList()) {
                this.addSplitPanel(encounter.getName().getName(), TempleTrackerOverlayPanel.millisToMinuteString(encounter.getEndTime() - encounter.getStartTime()));
            }
            if (tracker.getLatestEncounter() != null) {
                endTime = tracker.getLatestEncounter().getEndTime() > 0L ? tracker.getLatestEncounter().getEndTime() : System.currentTimeMillis();
                this.addSplitPanel(tracker.getLatestEncounter().getName().getName(), TempleTrackerOverlayPanel.millisToMinuteString(endTime - tracker.getLatestEncounter().getStartTime()));
            }
        }
        return super.render(graphics);
    }

    private static String millisToMinuteString(long time) {
        long minutes = time / 1000L / 60L;
        long seconds = time / 1000L % 60L;
        return minutes + ":" + (seconds < 10L ? "0" : "") + seconds;
    }
}

