/*
 * Decompiled with CFR 0.152.
 */
package com.templetracker.menuentryswapper;

import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Provides;
import com.templetracker.constructors.Companion;
import com.templetracker.menuentryswapper.MenuSwapperConfig;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Temple Trekking Swapper", description="Adds the possibility to swap to continue-trek, escort (companion), and use on the druid pouch")
public class MenuSwapperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MenuSwapperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private MenuSwapperConfig config;
    private final ArrayListMultimap<String, Integer> optionIndexes = ArrayListMultimap.create();

    @Provides
    MenuSwapperConfig provideConfig(ConfigManager configManager) {
        return (MenuSwapperConfig)configManager.getConfig(MenuSwapperConfig.class);
    }

    public void startUp() {
    }

    public void shutDown() {
    }

    @Subscribe(priority=10.0f)
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int idx = 0;
        this.optionIndexes.clear();
        for (MenuEntry entry : menuEntries) {
            String option = Text.removeTags((String)entry.getOption()).toLowerCase();
            this.optionIndexes.put((Object)option, (Object)idx++);
        }
        idx = 0;
        for (MenuEntry entry : menuEntries) {
            this.swapMenuEntry(entry, menuEntries, idx++);
        }
    }

    private void swapMenuEntry(MenuEntry menuEntry, MenuEntry[] menuEntries, int index) {
        String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
        String target = Text.removeTags((String)menuEntry.getTarget()).toLowerCase();
        if (this.config.swapContinueTrek() && option.equals("look-at") && target.equals("path")) {
            this.swap("continue-trek", option, target, menuEntries, index);
        } else if (this.config.swapUsePouch() && option.equals("fill") && target.equals("druid pouch")) {
            this.swap("use", option, target, menuEntries, index);
        } else if (this.config.swapEscort() && option.equals("talk-to") && Companion.getCompanion(target) != null) {
            this.swap("escort", option, target, menuEntries, index);
        }
    }

    private void swap(String priority, String option, String target, MenuEntry[] entries, int index) {
        int thisIndex = this.findIndex(entries, index, option, target);
        int optionIdx = this.findIndex(entries, thisIndex, priority, target);
        if (thisIndex >= 0 && optionIdx >= 0) {
            this.swap(optionIdx, thisIndex, entries);
        }
    }

    private void swap(int index1, int index2, MenuEntry[] entries) {
        MenuEntry entry = entries[index1];
        entries[index1] = entries[index2];
        entries[index2] = entry;
        this.client.setMenuEntries(entries);
    }

    private int findIndex(MenuEntry[] entries, int limit, String option, String target) {
        List indexes = this.optionIndexes.get((Object)option);
        for (int i = indexes.size() - 1; i >= 0; --i) {
            int idx = (Integer)indexes.get(i);
            MenuEntry entry = entries[idx];
            String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
            if (idx > limit || !entryTarget.equals(target)) continue;
            return idx;
        }
        return -1;
    }
}

