/*
 * Decompiled with CFR 0.152.
 */
package com.templetracker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.templetracker.constructors.TempleTracker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import net.runelite.client.RuneLite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReadWriter {
    private static final Logger log = LoggerFactory.getLogger(FileReadWriter.class);
    private String username;
    private String dir_TT;

    private void createFolders() {
        File dir = new File(RuneLite.RUNELITE_DIR, "temple-tracker");
        this.IGNORE_RESULT(dir.mkdir());
        dir = new File(dir, this.username);
        this.IGNORE_RESULT(dir.mkdir());
        File newTTFile = new File(dir + "\\temple_trek_data.log");
        try {
            this.IGNORE_RESULT(newTTFile.createNewFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dir_TT = dir.getAbsolutePath();
    }

    public void updateUsername(String username) {
        this.username = username;
        this.createFolders();
    }

    public void writeToFile(TempleTracker templeTracker) {
        try {
            Gson gson = new GsonBuilder().create();
            String fileName = this.dir_TT + "\\temple_trek_data.log";
            FileWriter fw = new FileWriter(fileName, true);
            gson.toJson((Object)templeTracker, (Appendable)fw);
            fw.append("\n");
            fw.close();
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage() + " in writeToFile");
        }
    }

    public ArrayList<TempleTracker> readFromFile() {
        try {
            String line;
            Gson gson = new GsonBuilder().create();
            String fileName = this.dir_TT + "\\temple_trek_data.log";
            JsonParser parser = new JsonParser();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(fileName));
            ArrayList<TempleTracker> TTList = new ArrayList<TempleTracker>();
            while ((line = bufferedreader.readLine()) != null && line.length() > 0) {
                try {
                    TempleTracker parsed = (TempleTracker)gson.fromJson(parser.parse(line), TempleTracker.class);
                    TTList.add(parsed);
                }
                catch (JsonSyntaxException e) {
                    System.out.println("Bad line: " + line);
                }
            }
            bufferedreader.close();
            return TTList;
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage() + " in writeToFile");
            return new ArrayList<TempleTracker>();
        }
    }

    public void IGNORE_RESULT(boolean b) {
    }
}

