/*
 * Decompiled with CFR 0.152.
 */
package com.improvedtearsinterface;

import com.improvedtearsinterface.DeltaInstantPair;
import com.improvedtearsinterface.ImprovedTearsInterfaceConfig;
import com.improvedtearsinterface.ImprovedTearsInterfacePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TextComponent;

class TearsPlusMinusOverlay
extends Overlay {
    private static final double HEIGHTS = 4.0;
    private static final long DURATION = 2000L;
    private static final int START_OFFSET_X = 10;
    private static final int START_OFFSET_Y = 0;
    private final Client client;
    private final ImprovedTearsInterfacePlugin plugin;
    private final ImprovedTearsInterfaceConfig config;
    private final TextComponent textComponent = new TextComponent();
    private final DecimalFormat fmt = new DecimalFormat("+#;-#");

    @Inject
    TearsPlusMinusOverlay(Client client, ImprovedTearsInterfacePlugin plugin, ImprovedTearsInterfaceConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showPlusMinusOnCollect() || this.plugin.getDeltaInstantQueue().isEmpty()) {
            return null;
        }
        Widget counter = this.client.getWidget(276, 19);
        if (counter != null) {
            Rectangle bounds = counter.getBounds();
            int x = bounds.x + bounds.width + 10;
            int y = bounds.y + bounds.height + 0;
            int h = bounds.height;
            Instant now = Instant.now();
            for (DeltaInstantPair dip : this.plugin.getDeltaInstantQueue()) {
                double ratio;
                int delta = dip.getDelta();
                if (delta == 0 || (ratio = (double)Duration.between(dip.getTime(), now).toMillis() / 2000.0) < 0.0 || ratio > 1.0) continue;
                this.textComponent.setText(this.fmt.format(delta));
                this.textComponent.setColor(delta > 0 ? Color.GREEN : Color.RED);
                this.textComponent.setOutline(false);
                this.textComponent.setPosition(new Point(x, y - (int)(ratio * (double)h * 4.0)));
                this.textComponent.render(graphics);
            }
        }
        return null;
    }
}

