/*
 * Decompiled with CFR 0.152.
 */
package com.improvedtearsinterface;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.improvedtearsinterface.DeltaInstantPair;
import com.improvedtearsinterface.ImprovedTearsInterfaceConfig;
import com.improvedtearsinterface.TearCollectingState;
import com.improvedtearsinterface.TearsPlusMinusOverlay;
import java.awt.Color;
import java.time.Instant;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Improved Tears Interface", description="Improves the Tears of Guthix minigame interface with a proper tick timer and current action indicator", tags={"Tears", "Guthix", "Tears of Guthix", "Improved", "Interface", "Minigame"})
public class ImprovedTearsInterfacePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ImprovedTearsInterfacePlugin.class);
    private static final int VARBIT_TICKS_LEFT = 5099;
    private static final int VARBIT_TEARS_COLLECTED = 455;
    private static final int VARBIT_COLLECTING = 453;
    private static final int TICKS_FROM_JUNAS_TAIL = 9;
    private static final int TICKS_FOR_START_TIMER = 6;
    private static final int TEARS_WP_PLANE = 2;
    private static final int TEARS_WP_MIN_X = 3251;
    private static final int TEARS_WP_MAX_X = 3260;
    private static final int TEARS_WP_MIN_Y = 9515;
    private static final int TEARS_WP_MAX_Y = 9519;
    static final int TEARS_WIDGET_GROUP_ID = 276;
    static final int TEARS_WIDGET_CHILD_TIME_TEXT = 17;
    static final int TEARS_WIDGET_CHILD_WATER_TEXT = 16;
    static final int TEARS_WIDGET_CHILD_COUNT_TEXT = 19;
    private static final int COLOR_YELLOW = 0xFFFF00;
    private static final int COLOR_LIGHT_ORANGE = 0xFF9900;
    private static final int COLOR_ORANGE = 0xFF6600;
    private static final int COLOR_RED = 0xFF0000;
    private static final int COLOR_LIGHT_BLUE = 48127;
    private static final int COLOR_BLUE = 26367;
    private static final int COLOR_GREEN = 65280;
    private static final int COLOR_DARK_GREEN = 52224;
    private static final Set<Integer> NO_TEARS_IDS = ImmutableSet.of((Object)6663, (Object)6667);
    private static final Set<Integer> BLUE_TEARS_IDS = ImmutableSet.of((Object)6661, (Object)6665);
    private static final Set<Integer> GREEN_TEARS_IDS = ImmutableSet.of((Object)6662, (Object)6666);
    private static final String TICK_LEFT_STRING = ColorUtil.wrapWithColorTag((String)"Ticks Left:", (Color)Color.YELLOW) + " %d / %d";
    private static final String NOT_COLLECTING_STRING = "Not Collecting";
    private static final String EMPTY_VEIN_STRING = "Empty Tear Vein!";
    private static final String BLUE_VEIN_STRING = ColorUtil.wrapWithColorTag((String)"Collecting", (Color)Color.GREEN) + " Blue " + ColorUtil.wrapWithColorTag((String)"Tears", (Color)Color.GREEN);
    private static final String GREEN_VEIN_STRING = ColorUtil.wrapWithColorTag((String)"Collecting", (Color)Color.RED) + " Green " + ColorUtil.wrapWithColorTag((String)"Tears", (Color)Color.RED);
    private static final String MINIGAME_STARTING_STRING = "Get Ready!";
    private static final String MINIGAME_STARTING_IN_SINGULAR_STRING = "Starting in: %d tick";
    private static final String MINIGAME_STARTING_IN_PLURAL_STRING = "Starting in: %d ticks";
    private static final String MINIGAME_ENDING_STRING = "Time Up!";
    @Inject
    private Client client;
    @Inject
    private ImprovedTearsInterfaceConfig config;
    @Inject
    private TearsPlusMinusOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private int maxTicks = 0;
    private int minigameStarting = 0;
    private boolean minigameEnding = false;
    private int ticksLeft = 0;
    private int displayedTicksLeft = 0;
    private int tearsCollected = 0;
    private TearCollectingState collectingState = TearCollectingState.NOT_COLLECTING;
    private EvictingQueue<DeltaInstantPair> deltaInstantQueue = EvictingQueue.create((int)10);
    private boolean turnedOnDuringMinigame = false;
    private boolean inTearsMinigame = false;

    @Provides
    ImprovedTearsInterfaceConfig provideConfig(ConfigManager configManager) {
        return (ImprovedTearsInterfaceConfig)configManager.getConfig(ImprovedTearsInterfaceConfig.class);
    }

    protected void startUp() throws Exception {
        this.reset();
        if (this.isInTearsMinigameArea() && this.client.getVarbitValue(5099) > 0) {
            this.turnedOnDuringMinigame = true;
        }
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        if (this.inTearsMinigame) {
            Widget tearsCountWidget;
            Widget waterTextWidget;
            Widget timeLeftWidget = this.client.getWidget(276, 17);
            if (timeLeftWidget != null) {
                timeLeftWidget.setText("Time Left");
                timeLeftWidget.setTextColor(0xFFFF00);
            }
            if ((waterTextWidget = this.client.getWidget(276, 16)) != null) {
                waterTextWidget.setText("Water Collected");
                waterTextWidget.setTextColor(0xFFFF00);
            }
            if ((tearsCountWidget = this.client.getWidget(276, 19)) != null) {
                tearsCountWidget.setTextColor(0xFFFF00);
            }
        }
        this.reset();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    private void reset() {
        this.maxTicks = 0;
        this.minigameStarting = 0;
        this.minigameEnding = false;
        this.ticksLeft = 0;
        this.displayedTicksLeft = 0;
        this.tearsCollected = 0;
        this.inTearsMinigame = false;
        this.turnedOnDuringMinigame = false;
        this.collectingState = TearCollectingState.NOT_COLLECTING;
        this.deltaInstantQueue.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.reset();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        int newTicksLeft;
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.turnedOnDuringMinigame) {
            if (!this.isInTearsMinigameArea(false)) {
                this.reset();
            } else {
                return;
            }
        }
        if ((newTicksLeft = this.client.getVarbitValue(5099)) > 0 && this.isInTearsMinigameArea()) {
            this.inTearsMinigame = true;
            if (this.ticksLeft == 0) {
                this.maxTicks = newTicksLeft;
                this.displayedTicksLeft = newTicksLeft;
                this.minigameStarting = 9;
            } else if (this.minigameStarting > 0) {
                if (this.isInTearsMinigameArea(false)) {
                    --this.minigameStarting;
                }
            } else if (newTicksLeft == this.ticksLeft) {
                if (this.displayedTicksLeft > 0) {
                    --this.displayedTicksLeft;
                }
            } else {
                this.displayedTicksLeft = newTicksLeft;
            }
        } else if (this.ticksLeft > 0) {
            this.minigameEnding = true;
            this.ticksLeft = 0;
            this.displayedTicksLeft = 0;
        }
        if (this.inTearsMinigame) {
            Widget timeLeftWidget = this.client.getWidget(276, 17);
            int newTearsCollected = this.client.getVarbitValue(455);
            this.collectingState = this.getCurrentCollectingState();
            if (timeLeftWidget != null) {
                boolean doFlash = this.config.getFlashingText() && this.client.getTickCount() % 2 != 0;
                timeLeftWidget.setText(String.format(TICK_LEFT_STRING, this.displayedTicksLeft, this.maxTicks));
                if (this.displayedTicksLeft > 0 && this.maxTicks > 0) {
                    double part = (double)this.displayedTicksLeft / (double)this.maxTicks;
                    if (part < 0.15) {
                        timeLeftWidget.setTextColor(doFlash ? 0xFF6600 : 0xFF0000);
                    } else if (part < 0.3) {
                        timeLeftWidget.setTextColor(0xFF9900);
                    } else if (part < 0.6) {
                        timeLeftWidget.setTextColor(0xFFFF00);
                    } else {
                        timeLeftWidget.setTextColor(65280);
                    }
                } else {
                    timeLeftWidget.setTextColor(0xFF0000);
                }
                Widget waterTextWidget = this.client.getWidget(276, 16);
                if (waterTextWidget != null) {
                    if (this.minigameStarting > 0) {
                        if (this.minigameStarting >= 6) {
                            waterTextWidget.setText(MINIGAME_STARTING_STRING);
                        } else if (this.minigameStarting == 1) {
                            waterTextWidget.setText(String.format(MINIGAME_STARTING_IN_SINGULAR_STRING, this.minigameStarting));
                        } else {
                            waterTextWidget.setText(String.format(MINIGAME_STARTING_IN_PLURAL_STRING, this.minigameStarting));
                        }
                        waterTextWidget.setTextColor(doFlash ? 52224 : 65280);
                    } else if (this.minigameEnding) {
                        waterTextWidget.setText(MINIGAME_ENDING_STRING);
                        waterTextWidget.setTextColor(doFlash ? 0xFF6600 : 0xFF0000);
                    } else {
                        switch (this.collectingState) {
                            case BLUE_VEIN: {
                                waterTextWidget.setText(BLUE_VEIN_STRING);
                                waterTextWidget.setTextColor(doFlash ? 26367 : 48127);
                                break;
                            }
                            case GREEN_VEIN: {
                                waterTextWidget.setText(GREEN_VEIN_STRING);
                                waterTextWidget.setTextColor(doFlash ? 52224 : 65280);
                                break;
                            }
                            case EMPTY_VEIN: {
                                waterTextWidget.setText(EMPTY_VEIN_STRING);
                                waterTextWidget.setTextColor(doFlash ? 0xFF9900 : 0xFF6600);
                                break;
                            }
                            default: {
                                waterTextWidget.setText(NOT_COLLECTING_STRING);
                                waterTextWidget.setTextColor(0xFFFF00);
                            }
                        }
                    }
                }
                int tearsDiff = newTearsCollected - this.tearsCollected;
                this.deltaInstantQueue.add((Object)DeltaInstantPair.builder().delta(tearsDiff).time(Instant.now()).build());
                Widget tearsCountWidget = this.client.getWidget(276, 19);
                if (tearsCountWidget != null) {
                    if (tearsDiff > 0) {
                        tearsCountWidget.setTextColor(65280);
                    } else if (tearsDiff < 0) {
                        tearsCountWidget.setTextColor(0xFF0000);
                    } else {
                        tearsCountWidget.setTextColor(0xFFFF00);
                    }
                }
            }
            if (this.minigameEnding && !this.isInTearsMinigameArea(false)) {
                this.reset();
            } else {
                this.ticksLeft = newTicksLeft;
                this.tearsCollected = newTearsCollected;
            }
        }
    }

    private boolean isInTearsMinigameArea() {
        return this.isInTearsMinigameArea(true);
    }

    private boolean isInTearsMinigameArea(boolean includeExterior) {
        Player lp = this.client.getLocalPlayer();
        if (lp != null) {
            WorldPoint wp = lp.getWorldLocation();
            return wp != null && wp.getPlane() == 2 && wp.getX() >= 3251 + (includeExterior ? 0 : 1) && wp.getX() <= 3260 && wp.getY() >= 9515 && wp.getY() <= 9519;
        }
        return false;
    }

    private TearCollectingState getCurrentCollectingState() {
        if (this.client.getVarbitValue(453) == 0) {
            return TearCollectingState.NOT_COLLECTING;
        }
        Player lp = this.client.getLocalPlayer();
        if (lp != null) {
            WorldPoint wp = lp.getWorldLocation();
            WorldPoint[] toCheck = new WorldPoint[]{wp.dx(1), wp.dy(1), wp.dy(-1)};
            Tile[][] tiles = this.client.getScene().getTiles()[wp.getPlane()];
            for (WorldPoint target : toCheck) {
                DecorativeObject obj;
                LocalPoint localTarget = LocalPoint.fromWorld((Client)this.client, (WorldPoint)target);
                if (localTarget == null || (obj = tiles[localTarget.getSceneX()][localTarget.getSceneY()].getDecorativeObject()) == null) continue;
                int id = obj.getId();
                if (NO_TEARS_IDS.contains(id)) {
                    return TearCollectingState.EMPTY_VEIN;
                }
                if (BLUE_TEARS_IDS.contains(id)) {
                    return TearCollectingState.BLUE_VEIN;
                }
                if (!GREEN_TEARS_IDS.contains(id)) continue;
                return TearCollectingState.GREEN_VEIN;
            }
        }
        return TearCollectingState.EMPTY_VEIN;
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public int getMinigameStarting() {
        return this.minigameStarting;
    }

    public boolean isMinigameEnding() {
        return this.minigameEnding;
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public int getDisplayedTicksLeft() {
        return this.displayedTicksLeft;
    }

    public int getTearsCollected() {
        return this.tearsCollected;
    }

    public TearCollectingState getCollectingState() {
        return this.collectingState;
    }

    public EvictingQueue<DeltaInstantPair> getDeltaInstantQueue() {
        return this.deltaInstantQueue;
    }
}

