/*
 * Decompiled with CFR 0.152.
 */
package com.tilepacks;

import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Provides;
import com.tilepacks.ColorTileMarker;
import com.tilepacks.GroundMarkerMinimapOverlay;
import com.tilepacks.GroundMarkerOverlay;
import com.tilepacks.GroundMarkerPoint;
import com.tilepacks.TilePack;
import com.tilepacks.TilePacksConfig;
import com.tilepacks.TilePacksPanel;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.groundmarkers.GroundMarkerPlugin;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Tile Packs")
@PluginDependency(value=GroundMarkerPlugin.class)
public class TilePacksPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TilePacksPlugin.class);
    private static final String CONFIG_GROUP = "tilePacks";
    private static final String REGION_PREFIX = "region_";
    private static final String CUSTOM_ID = "customId";
    private static final String CUSTOM_PACKS = "customPacks";
    private static final String PACKS_PREFIX = "packs";
    public static Map<Integer, TilePack> packs = new HashMap<Integer, TilePack>();
    @Inject
    private Client client;
    @Inject
    private TilePacksConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GroundMarkerMinimapOverlay minimapOverlay;
    @Inject
    private GroundMarkerOverlay overlay;
    private final List<ColorTileMarker> points = new ArrayList<ColorTileMarker>();
    private TilePacksPanel panel;
    private NavigationButton navButton;

    protected void startUp() throws Exception {
        this.deleteLegacyConfig();
        this.loadPacks();
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.panel = new TilePacksPanel(this, this.gson);
        BufferedImage icon = ImageUtil.loadImageResource(TilePacksPlugin.class, (String)"tilepacks_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Tile Packs").icon(icon).priority(4).panel((PluginPanel)this.panel).build();
        this.loadPoints();
        log.debug("Tile Packs Plugin started");
        if (this.config.hidePlugin()) {
            return;
        }
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.clientToolbar.removeNavigation(this.navButton);
        log.debug("Tile Packs Plugin stopped");
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("tilepacks")) {
            switch (event.getKey()) {
                case "hidePlugin": {
                    if (this.config.hidePlugin()) {
                        this.clientToolbar.removeNavigation(this.navButton);
                        break;
                    }
                    this.clientToolbar.addNavigation(this.navButton);
                }
            }
        }
    }

    void deleteLegacyConfig() {
        List oldConfigs = this.configManager.getConfigurationKeys("tilePacks.region_");
        if (oldConfigs.size() > 0) {
            for (String config : oldConfigs) {
                this.configManager.unsetConfiguration(CONFIG_GROUP, config.split("\\.")[1]);
            }
        }
    }

    List<GroundMarkerPoint> getActivePoints() {
        ArrayList<GroundMarkerPoint> markers = new ArrayList<GroundMarkerPoint>();
        List<Integer> enabledPacks = this.loadEnabledPacks();
        for (Map.Entry<Integer, TilePack> pack : packs.entrySet()) {
            if (!enabledPacks.contains(pack.getKey())) continue;
            markers.addAll((Collection)this.gson.fromJson(pack.getValue().packTiles, new TypeToken<List<GroundMarkerPoint>>(){}.getType()));
        }
        return markers;
    }

    List<GroundMarkerPoint> getActivePoints(int regionId) {
        List<GroundMarkerPoint> activePoints = this.getActivePoints();
        Map<Integer, List<GroundMarkerPoint>> regionGroupedPoints = activePoints.stream().collect(Collectors.groupingBy(GroundMarkerPoint::getRegionId));
        List<GroundMarkerPoint> regionPoints = regionGroupedPoints.get(regionId);
        if (regionPoints == null) {
            return Collections.emptyList();
        }
        return regionPoints;
    }

    void addEnabledPack(Integer packId) {
        List<Integer> packs = this.loadEnabledPacks();
        packs.add(packId);
        String json = this.gson.toJson(packs);
        this.configManager.setConfiguration(CONFIG_GROUP, PACKS_PREFIX, json);
    }

    void removeEnabledPack(Integer packId) {
        List<Integer> packs = this.loadEnabledPacks();
        packs.remove(packId);
        if (packs.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, PACKS_PREFIX);
            return;
        }
        String json = this.gson.toJson(packs);
        this.configManager.setConfiguration(CONFIG_GROUP, PACKS_PREFIX, json);
    }

    List<Integer> loadEnabledPacks() {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, PACKS_PREFIX);
        if (Strings.isNullOrEmpty((String)json)) {
            return new ArrayList<Integer>();
        }
        return (List)this.gson.fromJson(json, new TypeToken<List<Integer>>(){}.getType());
    }

    void loadPoints() {
        this.points.clear();
        int[] regions = this.client.getMapRegions();
        if (regions == null) {
            return;
        }
        for (int regionId : regions) {
            List<GroundMarkerPoint> regionPoints = this.getActivePoints(regionId);
            Collection<ColorTileMarker> colorTileMarkers = this.translateToColorTileMarker(regionPoints);
            this.points.addAll(colorTileMarkers);
        }
    }

    void loadPacks() {
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("tilePacks.jsonc");){
            InputStreamReader data = new InputStreamReader(in, StandardCharsets.UTF_8);
            Type type = new TypeToken<Map<Integer, TilePack>>(){}.getType();
            Map parsed = (Map)this.gson.fromJson((Reader)data, type);
            Map<Integer, TilePack> customPacks = this.loadCustomPacks();
            parsed.putAll(customPacks);
            packs = parsed;
        }
        catch (Exception e) {
            log.error("error loading packs from json, this is likely due to a bad json file.", (Throwable)e);
        }
    }

    Map<Integer, TilePack> loadCustomPacks() {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, CUSTOM_PACKS);
        if (Strings.isNullOrEmpty((String)json)) {
            return new HashMap<Integer, TilePack>();
        }
        return (Map)this.gson.fromJson(json, new TypeToken<Map<Integer, TilePack>>(){}.getType());
    }

    Integer loadCustomId() {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, CUSTOM_ID);
        if (Strings.isNullOrEmpty((String)json)) {
            return 9999;
        }
        return (Integer)this.gson.fromJson(json, new TypeToken<Integer>(){}.getType());
    }

    void addCustomPack(String name, String tiles) {
        Integer customId = this.loadCustomId() + 1;
        TilePack pack = new TilePack(customId, name, tiles);
        Map<Integer, TilePack> customPacks = this.loadCustomPacks();
        customPacks.put(customId, pack);
        String json = this.gson.toJson(customPacks);
        this.configManager.setConfiguration(CONFIG_GROUP, CUSTOM_PACKS, json);
        this.configManager.setConfiguration(CONFIG_GROUP, CUSTOM_ID, (Object)customId);
    }

    void removeCustomPack(Integer packId) {
        this.removeEnabledPack(packId);
        Map<Integer, TilePack> customPacks = this.loadCustomPacks();
        customPacks.remove(packId);
        if (customPacks.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, CUSTOM_PACKS);
            return;
        }
        String json = this.gson.toJson(customPacks);
        this.configManager.setConfiguration(CONFIG_GROUP, CUSTOM_PACKS, json);
    }

    private Collection<ColorTileMarker> translateToColorTileMarker(Collection<GroundMarkerPoint> points) {
        if (points.isEmpty()) {
            return Collections.emptyList();
        }
        return points.stream().map(point -> new ColorTileMarker(WorldPoint.fromRegion((int)point.getRegionId(), (int)point.getRegionX(), (int)point.getRegionY(), (int)point.getZ()), point.getColor(), point.getLabel())).flatMap(colorTile -> {
            Collection localWorldPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)colorTile.getWorldPoint());
            return localWorldPoints.stream().map(wp -> new ColorTileMarker((WorldPoint)wp, colorTile.getColor(), colorTile.getLabel()));
        }).collect(Collectors.toList());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.loadPoints();
    }

    @Provides
    TilePacksConfig provideConfig(ConfigManager configManager) {
        return (TilePacksConfig)configManager.getConfig(TilePacksConfig.class);
    }

    List<ColorTileMarker> getPoints() {
        return this.points;
    }
}

