/*
 * Decompiled with CFR 0.152.
 */
package com.tilepacks;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.tilepacks.CustomPackManager;
import com.tilepacks.PackPanel;
import com.tilepacks.TilePack;
import com.tilepacks.TilePacksPlugin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TilePacksPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(TilePacksPanel.class);
    private final TilePacksPlugin plugin;
    private final Gson gson;
    private final IconTextField searchBar;
    private final JPanel listContainer = new JPanel();

    TilePacksPanel(TilePacksPlugin plugin, Gson gson) {
        this.plugin = plugin;
        this.gson = gson;
        this.searchBar = new IconTextField();
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.setMinimumSize(new Dimension(0, 30));
        this.searchBar.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TilePacksPanel.this.loadPacks();
            }
        });
        this.searchBar.addClearListener(() -> this.loadPacks());
        this.add((Component)this.searchBar);
        this.add(this.listContainer);
        this.listContainer.setLayout(new GridLayout(0, 1, 0, 0));
        CustomPackManager customPackManager = new CustomPackManager(plugin, gson, this);
        this.add((Component)((Object)customPackManager));
        this.loadPacks();
    }

    void loadPacks() {
        this.listContainer.removeAll();
        String search = this.searchBar.getText();
        List<Integer> enabledPacks = this.plugin.loadEnabledPacks();
        for (Map.Entry<Integer, TilePack> pack : TilePacksPlugin.packs.entrySet()) {
            if (!Strings.isNullOrEmpty((String)search) && !pack.getValue().packName.toLowerCase().contains(search.toLowerCase())) continue;
            PackPanel tile = new PackPanel(this.plugin, this.gson, this, pack.getValue(), enabledPacks.contains(pack.getKey()));
            this.listContainer.add(tile);
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }
}

