/*
 * Decompiled with CFR 0.152.
 */
package com.tilepacks;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.tilepacks.GroundMarkerPoint;
import com.tilepacks.TilePack;
import com.tilepacks.TilePacksPanel;
import com.tilepacks.TilePacksPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PackPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(PackPanel.class);
    private static final int ROW_WIDTH = 215;
    private static final int ROW_HEIGHT = 30;
    private static final int RIGHT_PANEL_WIDTH = 40;
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_ICON_HOVER;
    private static final ImageIcon REMOVE_ICON;
    private static final ImageIcon REMOVE_ICON_HOVER;
    private static final ImageIcon HELP_ICON;
    private static final ImageIcon HELP_ICON_HOVER;
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_ICON_HOVER;
    private final TilePacksPlugin plugin;
    private final Gson gson;
    private final TilePacksPanel panel;
    private final JPanel rowContainer = new JPanel();
    private final JPanel rightPanel = new JPanel();
    private JLabel packName;
    private JLabel addPack;
    private JLabel removePack;
    private JLabel helpLink;
    private JLabel deleteCustomPack;
    private List<GroundMarkerPoint> points;

    PackPanel(final TilePacksPlugin plugin, Gson gson, final TilePacksPanel panel, final TilePack pack, boolean enabled) {
        this.plugin = plugin;
        this.gson = gson;
        this.panel = panel;
        log.debug("Loading pack - {}", (Object)pack.packName);
        this.points = (List)gson.fromJson(pack.packTiles, new TypeToken<List<GroundMarkerPoint>>(){}.getType());
        this.rowContainer.setLayout(new BorderLayout());
        this.rowContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.rowContainer.setPreferredSize(new Dimension(215, 30));
        this.rowContainer.setBorder(new EmptyBorder(8, 8, 6, 8));
        this.add(this.rowContainer);
        this.packName = new JLabel(pack.packName);
        this.packName.setFont(FontManager.getRunescapeFont());
        this.rowContainer.add((Component)this.packName, "West");
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.rightPanel.setPreferredSize(new Dimension(40, 30));
        this.rowContainer.add((Component)this.rightPanel, "East");
        this.addPack = new JLabel();
        this.addPack.setIcon(ADD_ICON);
        this.addPack.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    plugin.addEnabledPack(pack.id);
                    plugin.loadPoints();
                    PackPanel.this.removePack.setIcon(REMOVE_ICON_HOVER);
                    PackPanel.this.rightPanel.add((Component)PackPanel.this.removePack, "East");
                    PackPanel.this.rightPanel.remove(PackPanel.this.addPack);
                    PackPanel.this.rightPanel.revalidate();
                    PackPanel.this.rightPanel.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PackPanel.this.addPack.setIcon(ADD_ICON_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PackPanel.this.addPack.setIcon(ADD_ICON);
            }
        });
        this.removePack = new JLabel();
        this.removePack.setIcon(REMOVE_ICON);
        this.removePack.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    plugin.removeEnabledPack(pack.id);
                    plugin.loadPoints();
                    PackPanel.this.addPack.setIcon(ADD_ICON_HOVER);
                    PackPanel.this.rightPanel.add((Component)PackPanel.this.addPack, "East");
                    PackPanel.this.rightPanel.remove(PackPanel.this.removePack);
                    PackPanel.this.rightPanel.revalidate();
                    PackPanel.this.rightPanel.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PackPanel.this.removePack.setIcon(REMOVE_ICON_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PackPanel.this.removePack.setIcon(REMOVE_ICON);
            }
        });
        if (pack.link != null && pack.link != "") {
            this.helpLink = new JLabel();
            this.helpLink.setIcon(HELP_ICON);
            this.helpLink.setToolTipText("Click to open source of pack in browser");
            this.helpLink.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        LinkBrowser.browse((String)pack.link);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PackPanel.this.helpLink.setIcon(HELP_ICON_HOVER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PackPanel.this.helpLink.setIcon(HELP_ICON);
                }
            });
            this.rightPanel.add((Component)this.helpLink, "West");
        }
        if (enabled) {
            this.rightPanel.add((Component)this.removePack, "East");
        } else {
            this.rightPanel.add((Component)this.addPack, "East");
        }
        if (pack.id >= 10000) {
            this.deleteCustomPack = new JLabel();
            this.deleteCustomPack.setIcon(DELETE_ICON);
            this.deleteCustomPack.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int result;
                    if (SwingUtilities.isLeftMouseButton(e) && (result = JOptionPane.showOptionDialog(PackPanel.this.rowContainer, "Are you sure you want to delete this pack?", "Delete Pack?", 0, 2, null, new String[]{"Yes", "No"}, "No")) == 0) {
                        plugin.removeCustomPack(pack.id);
                        plugin.loadPacks();
                        plugin.loadPoints();
                        panel.loadPacks();
                        PackPanel.this.rightPanel.revalidate();
                        PackPanel.this.rightPanel.repaint();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PackPanel.this.deleteCustomPack.setIcon(DELETE_ICON_HOVER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PackPanel.this.deleteCustomPack.setIcon(DELETE_ICON);
                }
            });
            this.rightPanel.add((Component)this.deleteCustomPack, "West");
        }
    }

    static {
        BufferedImage addIcon = ImageUtil.loadImageResource(TilePacksPlugin.class, (String)"add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (float)0.53f));
        BufferedImage removeIcon = ImageUtil.loadImageResource(TilePacksPlugin.class, (String)"remove_icon.png");
        REMOVE_ICON = new ImageIcon(removeIcon);
        REMOVE_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)removeIcon, (float)0.5f));
        BufferedImage helpIcon = ImageUtil.loadImageResource(TilePacksPlugin.class, (String)"help_icon.png");
        HELP_ICON = new ImageIcon(helpIcon);
        HELP_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)helpIcon, (float)0.5f));
        BufferedImage deleteIcon = ImageUtil.loadImageResource(TilePacksPlugin.class, (String)"delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteIcon);
        DELETE_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)deleteIcon, (float)0.5f));
    }
}

