/*
 * Decompiled with CFR 0.152.
 */
package com.tilepacks;

import com.tilepacks.ColorTileMarker;
import com.tilepacks.TilePacksConfig;
import com.tilepacks.TilePacksPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

class GroundMarkerMinimapOverlay
extends Overlay {
    private final Client client;
    private final TilePacksConfig config;
    private final TilePacksPlugin plugin;

    @Inject
    private GroundMarkerMinimapOverlay(Client client, TilePacksConfig config, TilePacksPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.drawTilesOnMinimmap()) {
            return null;
        }
        List<ColorTileMarker> points = this.plugin.getPoints();
        for (ColorTileMarker point : points) {
            WorldPoint worldPoint = point.getWorldPoint();
            if (worldPoint.getPlane() != this.client.getPlane()) continue;
            Color tileColor = this.config.overrideColorActive() ? this.config.overrideColor() : point.getColor();
            this.drawOnMinimap(graphics, worldPoint, tileColor);
        }
        return null;
    }

    private void drawOnMinimap(Graphics2D graphics, WorldPoint point, Color color) {
        if (!point.isInScene(this.client)) {
            return;
        }
        int x = point.getX() - this.client.getBaseX();
        int y = point.getY() - this.client.getBaseY();
        Point mp1 = Perspective.localToMinimap((Client)this.client, (LocalPoint)new LocalPoint(x <<= 7, y <<= 7));
        Point mp2 = Perspective.localToMinimap((Client)this.client, (LocalPoint)new LocalPoint(x, y + 128));
        Point mp3 = Perspective.localToMinimap((Client)this.client, (LocalPoint)new LocalPoint(x + 128, y + 128));
        Point mp4 = Perspective.localToMinimap((Client)this.client, (LocalPoint)new LocalPoint(x + 128, y));
        if (mp1 == null || mp2 == null || mp3 == null || mp4 == null) {
            return;
        }
        Polygon poly = new Polygon();
        poly.addPoint(mp1.getX(), mp1.getY());
        poly.addPoint(mp2.getX(), mp2.getY());
        poly.addPoint(mp3.getX(), mp3.getY());
        poly.addPoint(mp4.getX(), mp4.getY());
        BasicStroke stroke = new BasicStroke(1.0f);
        graphics.setStroke(stroke);
        graphics.setColor(color);
        graphics.drawPolygon(poly);
    }
}

