/*
 * Decompiled with CFR 0.152.
 */
package com.tilepacks;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.tilepacks.GroundMarkerPoint;
import com.tilepacks.TilePacksPanel;
import com.tilepacks.TilePacksPlugin;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.FlatTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPackManager
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(CustomPackManager.class);
    private final TilePacksPlugin plugin;
    private final Gson gson;
    private final TilePacksPanel panel;
    private final JLabel inputLabel;
    private final FlatTextField nameInput;
    private final JLabel tilesLabel;
    private final FlatTextField tilesInput;
    private final JButton addPackButton;

    CustomPackManager(TilePacksPlugin plugin, Gson gson, TilePacksPanel panel) {
        this.plugin = plugin;
        this.gson = gson;
        this.panel = panel;
        this.inputLabel = new JLabel("Custom Pack Name");
        this.add(this.inputLabel);
        this.nameInput = new FlatTextField();
        this.nameInput.setPreferredSize(new Dimension(205, 30));
        this.nameInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameInput.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.nameInput.setMinimumSize(new Dimension(0, 30));
        this.add((Component)this.nameInput);
        this.tilesLabel = new JLabel("Custom Pack Tiles");
        this.add(this.tilesLabel);
        this.tilesInput = new FlatTextField();
        this.tilesInput.setPreferredSize(new Dimension(205, 30));
        this.tilesInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.tilesInput.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.tilesInput.setMinimumSize(new Dimension(0, 30));
        this.add((Component)this.tilesInput);
        this.addPackButton = new JButton();
        this.addPackButton.setText("Add Pack");
        this.addPackButton.setHorizontalAlignment(0);
        this.addPackButton.setFocusable(false);
        this.addPackButton.setPreferredSize(new Dimension(215, 30));
        this.addPackButton.addActionListener(e -> {
            List importPoints;
            if (this.nameInput.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.inputLabel, "Must add a pack name");
                return;
            }
            if (this.tilesInput.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.inputLabel, "Must add tiles");
            }
            try {
                importPoints = (List)gson.fromJson(this.tilesInput.getText(), new TypeToken<List<GroundMarkerPoint>>(){}.getType());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.inputLabel, "Error parsing tiles, check the formatting");
                return;
            }
            if (importPoints.isEmpty()) {
                JOptionPane.showMessageDialog(this.inputLabel, "Error parsing tiles, check the formatting");
                return;
            }
            plugin.addCustomPack(this.nameInput.getText(), this.tilesInput.getText());
            plugin.loadPacks();
            panel.loadPacks();
        });
        this.add(this.addPackButton);
    }
}

