/*
 * Decompiled with CFR 0.152.
 */
package com.specoverlay;

import com.google.inject.Provides;
import com.specoverlay.SpecOverlayConfig;
import com.specoverlay.SpecOverlayCounter;
import com.specoverlay.SpecOverlayOverlay;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Spec Overlay")
public class SpecOverlayPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpecOverlayPlugin.class);
    @Inject
    private Client client;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SpecOverlayConfig specOverlayConfig;
    @Inject
    private ItemManager itemManager;
    private SpecOverlayCounter specOverlayCounter;
    private SpecOverlayOverlay specOverlayOverlay;
    private static final int SoulReaperAxe = 28338;
    static final String ConfigGroupKey = "SpecOverlay";
    @Inject
    SpriteManager spriteManager;

    protected void startUp() throws Exception {
        this.specOverlayCounter = new SpecOverlayCounter(this, this.client.getVarpValue(300) / 10, null);
        this.specOverlayOverlay = new SpecOverlayOverlay(this, this.specOverlayConfig, this.client.getVarpValue(300) / 10);
    }

    protected void shutDown() throws Exception {
        if (this.specOverlayConfig.info() == SpecOverlayConfig.OverlayType.INFOBOX) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.specOverlayCounter);
        } else if (this.specOverlayConfig.info() == SpecOverlayConfig.OverlayType.OVERLAY) {
            this.overlayManager.remove((Overlay)this.specOverlayOverlay);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getItemContainer() != this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            return;
        }
        if (Objects.requireNonNull(this.client.getItemContainer(InventoryID.EQUIPMENT)).contains(28338)) {
            if (this.specOverlayConfig.info() == SpecOverlayConfig.OverlayType.INFOBOX) {
                this.specOverlayCounter.setImage(this.spriteManager.getSprite(1610, 0));
                if (!this.infoBoxManager.getInfoBoxes().contains((Object)this.specOverlayCounter)) {
                    this.infoBoxManager.addInfoBox((InfoBox)this.specOverlayCounter);
                }
            } else if (this.specOverlayConfig.info() == SpecOverlayConfig.OverlayType.OVERLAY) {
                this.overlayManager.add((Overlay)this.specOverlayOverlay);
            }
        } else if (this.specOverlayConfig.info() == SpecOverlayConfig.OverlayType.INFOBOX) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.specOverlayCounter);
        } else if (this.specOverlayConfig.info() == SpecOverlayConfig.OverlayType.OVERLAY) {
            this.overlayManager.remove((Overlay)this.specOverlayOverlay);
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.updateInfoBox();
        this.updateOverlay();
    }

    private void updateInfoBox() {
        this.specOverlayCounter.setCount(this.client.getVarpValue(300) / 10);
    }

    private void updateOverlay() {
        this.specOverlayOverlay.Spec = this.client.getVarpValue(300) / 10;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(ConfigGroupKey) && this.client.getItemContainer(InventoryID.EQUIPMENT).contains(28338)) {
            if (event.getOldValue().equals("OVERLAY")) {
                this.overlayManager.remove((Overlay)this.specOverlayOverlay);
                this.infoBoxManager.addInfoBox((InfoBox)this.specOverlayCounter);
            } else if (event.getOldValue().equals("INFOBOX")) {
                this.overlayManager.add((Overlay)this.specOverlayOverlay);
                this.infoBoxManager.removeInfoBox((InfoBox)this.specOverlayCounter);
            }
        }
    }

    @Provides
    SpecOverlayConfig provideConfig(ConfigManager configManager) {
        return (SpecOverlayConfig)configManager.getConfig(SpecOverlayConfig.class);
    }
}

