/*
 * Decompiled with CFR 0.152.
 */
package com.localtime;

import com.google.inject.Provides;
import com.localtime.LocalTimeConfig;
import com.localtime.LocalTimeOverlay;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Local Time")
public class LocalTimePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LocalTimePlugin.class);
    @Inject
    private Client client;
    @Inject
    private LocalTimeConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private LocalTimeOverlay localTimeOverlay;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.localTimeOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.localTimeOverlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("rl-local-time")) {
            // empty if block
        }
    }

    @Provides
    LocalTimeConfig provideConfig(ConfigManager configManager) {
        return (LocalTimeConfig)configManager.getConfig(LocalTimeConfig.class);
    }
}

