/*
 * Decompiled with CFR 0.152.
 */
package com.localtime;

import com.localtime.LocalTimeConfig;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class LocalTimeOverlay
extends Overlay {
    private final LocalTimeConfig config;
    private String timeFormat;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    public LocalTimeOverlay(LocalTimeConfig config) {
        this.setResizable(true);
        this.setPreferredPosition(OverlayPosition.TOP_RIGHT);
        this.setSnappable(true);
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        ZonedDateTime currentTime = ZonedDateTime.now();
        String string = this.timeFormat = this.config.use24Hr() ? "HH:mm" : "h:mm";
        if (this.config.showSeconds()) {
            this.timeFormat = this.timeFormat + ":ss";
        }
        String formattedTime = currentTime.format(DateTimeFormatter.ofPattern(this.timeFormat));
        this.panelComponent.getChildren().clear();
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(formattedTime) + 8, 0));
        this.panelComponent.getChildren().add(LineComponent.builder().left(formattedTime).build());
        return this.panelComponent.render(graphics);
    }
}

