/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.ui.panels;

import com.adamk33n3r.runelite.watchdog.Displayable;
import com.adamk33n3r.runelite.watchdog.TriggerType;
import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.ui.Icons;
import com.adamk33n3r.runelite.watchdog.ui.PlaceholderTextArea;
import com.adamk33n3r.runelite.watchdog.ui.dropdownbutton.DropDownButtonFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.components.ColorJButton;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;
import org.apache.commons.text.WordUtils;

public class PanelUtils {
    private static final ImageIcon FOLDER;

    private PanelUtils() {
    }

    public static JPanel createLabeledComponent(String label, String tooltip, Component component) {
        return PanelUtils.createLabeledComponent(label, tooltip, component, false);
    }

    public static JPanel createLabeledComponent(String label, String tooltip, Component component, boolean twoLines) {
        JPanel panel = new JPanel();
        if (twoLines) {
            panel.setLayout((LayoutManager)new DynamicGridLayout(2, 0, 5, 5));
        } else {
            panel.setBorder(new EmptyBorder(0, 5, 0, 0));
            panel.setLayout(new BorderLayout(5, 0));
        }
        JLabel jLabel = new JLabel(label);
        jLabel.setToolTipText(tooltip);
        panel.add((Component)jLabel, "West");
        panel.add(component);
        return panel;
    }

    public static JPanel createIconComponent(ImageIcon icon, String tooltip, Component component) {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.setBackground(null);
        JLabel jLabel = new JLabel(icon);
        jLabel.setToolTipText(tooltip);
        panel.add((Component)jLabel, "West");
        panel.add(component);
        return panel;
    }

    public static JPanel createFileChooser(String label, String tooltip, ActionListener actionListener, String path, final String filterLabel, final String ... filters) {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setBackground(null);
        if (label != null) {
            panel.setLayout(new GridLayout(2, 1));
            JLabel jLabel = new JLabel(label);
            jLabel.setToolTipText(tooltip);
            panel.add(jLabel);
        }
        JPanel chooserPanel = new JPanel(new BorderLayout(5, 0));
        chooserPanel.setBackground(null);
        panel.add(chooserPanel);
        JTextField pathField = new JTextField(path);
        pathField.setToolTipText(path);
        pathField.setEditable(false);
        chooserPanel.add(pathField);
        JFileChooser fileChooser = new JFileChooser(path);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String fileName = file.getName();
                int i = fileName.lastIndexOf(46);
                String extension = null;
                if (i > 0 && i < fileName.length() - 1) {
                    extension = fileName.substring(i + 1).toLowerCase();
                }
                if (extension != null) {
                    return Arrays.asList(filters).contains(extension);
                }
                return false;
            }

            @Override
            public String getDescription() {
                return filterLabel + Arrays.stream(filters).map(ft -> "*." + ft).collect(Collectors.joining(", ", " (", ")"));
            }
        });
        JButton fileChooserButton = new JButton(null, FOLDER);
        fileChooserButton.setToolTipText(tooltip);
        fileChooserButton.addActionListener(e -> {
            int result = fileChooser.showOpenDialog(panel);
            if (result == 0) {
                String absPath = fileChooser.getSelectedFile().getAbsolutePath();
                pathField.setText(absPath);
                pathField.setToolTipText(absPath);
                actionListener.actionPerformed(new ActionEvent(fileChooser, result, "selected"));
            }
        });
        chooserPanel.add((Component)fileChooserButton, "East");
        return panel;
    }

    public static JButton createActionButton(ImageIcon icon, ImageIcon rolloverIcon, String tooltip, ButtonClickListener listener) {
        JButton actionButton = new JButton();
        SwingUtil.removeButtonDecorations((AbstractButton)actionButton);
        actionButton.setPreferredSize(new Dimension(16, 16));
        actionButton.setIcon(icon);
        actionButton.setRolloverIcon(rolloverIcon);
        actionButton.setToolTipText(tooltip);
        actionButton.addActionListener(ev -> listener.clickPerformed(actionButton, ev.getModifiers()));
        return actionButton;
    }

    public static JButton createToggleActionButton(ImageIcon onIcon, ImageIcon onRolloverIcon, ImageIcon offIcon, ImageIcon offRolloverIcon, String onTooltip, String offTooltip, boolean initialValue, ButtonClickListener listener) {
        JButton actionButton = PanelUtils.createActionButton(offIcon, offRolloverIcon, offTooltip, (btn, modifiers) -> {
            btn.setSelected(!btn.isSelected());
            listener.clickPerformed(btn, modifiers);
        });
        SwingUtil.addModalTooltip((AbstractButton)actionButton, (String)onTooltip, (String)offTooltip);
        actionButton.setSelectedIcon(onIcon);
        actionButton.setRolloverSelectedIcon(onRolloverIcon);
        actionButton.setSelected(initialValue);
        return actionButton;
    }

    public static JCheckBox createCheckbox(String name, String tooltip, boolean initialValue, Consumer<Boolean> onChange) {
        JCheckBox checkbox = new JCheckBox(name, initialValue);
        checkbox.setToolTipText(tooltip);
        checkbox.addItemListener(ev -> onChange.accept(checkbox.isSelected()));
        return checkbox;
    }

    public static JTextArea createTextArea(String placeholder, String tooltip, String initialValue, final Consumer<String> onChange) {
        final PlaceholderTextArea textArea = new PlaceholderTextArea(initialValue);
        textArea.setPlaceholder(placeholder);
        textArea.setToolTipText(tooltip);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setMargin(new Insets(4, 6, 5, 6));
        textArea.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                textArea.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                onChange.accept(textArea.getText());
            }
        });
        return textArea;
    }

    public static JSpinner createSpinner(int initialValue, int min, int max, int step, Consumer<Integer> onChange) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(initialValue, min, max, step));
        spinner.addChangeListener(e -> onChange.accept((Integer)spinner.getValue()));
        return spinner;
    }

    public static ColorJButton createColorPicker(String placeholder, String tooltip, final String windowTitle, final Component parentComponent, Color initialValue, final ColorPickerManager colorPickerManager, final boolean showAlpha, final Consumer<Color> onChange) {
        final ColorJButton colorPickerBtn = new ColorJButton(placeholder, Color.BLACK);
        if (initialValue != null) {
            String colorHex = "#" + ColorUtil.colorToAlphaHexCode((Color)initialValue).toUpperCase();
            colorPickerBtn.setText(colorHex);
            colorPickerBtn.setColor(initialValue);
        }
        colorPickerBtn.setToolTipText(tooltip);
        colorPickerBtn.setFocusable(false);
        colorPickerBtn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RuneliteColorPicker colorPicker = colorPickerManager.create(SwingUtilities.getWindowAncestor((Component)colorPickerBtn), colorPickerBtn.getColor(), windowTitle, !showAlpha);
                colorPicker.setLocation(parentComponent.getLocationOnScreen());
                colorPicker.setOnColorChange(c -> {
                    colorPickerBtn.setColor(c);
                    colorPickerBtn.setText("#" + ColorUtil.colorToAlphaHexCode((Color)c).toUpperCase());
                });
                colorPicker.setOnClose(onChange);
                colorPicker.setVisible(true);
            }
        });
        return colorPickerBtn;
    }

    public static <T extends Enum<T>> JComboBox<T> createSelect(T[] items, T initialValue, Consumer<T> onChange) {
        JComboBox select = new JComboBox(items);
        select.setSelectedItem(initialValue);
        select.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            if (value instanceof Displayable) {
                list.setToolTipText(((Displayable)((Object)value)).getTooltip());
                return new DefaultListCellRenderer().getListCellRendererComponent((JList<?>)list, ((Displayable)((Object)value)).getName(), index, isSelected, cellHasFocus);
            }
            String titleized = value == null ? "null" : WordUtils.capitalizeFully((String)value.name());
            list.setToolTipText(titleized);
            return new DefaultListCellRenderer().getListCellRendererComponent((JList<?>)list, titleized, index, isSelected, cellHasFocus);
        });
        select.addActionListener(e -> onChange.accept((Enum)select.getItemAt(select.getSelectedIndex())));
        return select;
    }

    public static <T> JComboBox<T> createSelect(T[] items, T initialValue, @Nullable Function<T, String> onRender, Consumer<T> onChange) {
        JComboBox select = new JComboBox(items);
        select.setSelectedItem(initialValue);
        select.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            if (onRender != null) {
                String title = value == null ? "Loading..." : (String)onRender.apply(value);
                return new DefaultListCellRenderer().getListCellRendererComponent((JList<?>)list, title, index, isSelected, cellHasFocus);
            }
            if (value instanceof Displayable) {
                list.setToolTipText(((Displayable)value).getTooltip());
                return new DefaultListCellRenderer().getListCellRendererComponent((JList<?>)list, ((Displayable)value).getName(), index, isSelected, cellHasFocus);
            }
            String titleized = value == null ? "null" : WordUtils.capitalizeFully((String)value.toString());
            list.setToolTipText(titleized);
            return new DefaultListCellRenderer().getListCellRendererComponent((JList<?>)list, titleized, index, isSelected, cellHasFocus);
        });
        select.addActionListener(e -> onChange.accept(select.getItemAt(select.getSelectedIndex())));
        return select;
    }

    public static boolean isPatternValid(Component parent, String pattern, boolean isRegex) {
        try {
            Pattern.compile(isRegex ? pattern : Util.createRegexFromGlob(pattern));
            return true;
        }
        catch (PatternSyntaxException ex) {
            JLabel errorLabel = new JLabel("<html>" + ex.getMessage().replaceAll("\n", "<br/>").replaceAll(" ", "&nbsp;") + "</html>");
            errorLabel.setFont(new Font("Monospaced", 0, 12));
            JOptionPane.showMessageDialog(parent, errorLabel, "Error in regex/pattern", 0);
            return false;
        }
    }

    public static JButton createAlertDropDownButton(Consumer<Alert> onCreate) {
        ActionListener actionListener = e -> {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            TriggerType tType = (TriggerType)((Object)((Object)menuItem.getClientProperty(TriggerType.class)));
            Alert createdAlert = (Alert)WatchdogPlugin.getInstance().getInjector().getInstance(tType.getImplClass());
            onCreate.accept(createdAlert);
        };
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem alertGroupMenuItem = new JMenuItem(TriggerType.ALERT_GROUP.getName());
        alertGroupMenuItem.setToolTipText(TriggerType.ALERT_GROUP.getTooltip());
        alertGroupMenuItem.putClientProperty(TriggerType.class, (Object)TriggerType.ALERT_GROUP);
        alertGroupMenuItem.addActionListener(actionListener);
        popupMenu.add(alertGroupMenuItem);
        popupMenu.addSeparator();
        Arrays.stream(TriggerType.values()).filter(tType -> tType != TriggerType.ALERT_GROUP).forEach(tType -> {
            JMenuItem c = new JMenuItem(tType.getName());
            c.setToolTipText(tType.getTooltip());
            c.putClientProperty(TriggerType.class, tType);
            c.addActionListener(actionListener);
            popupMenu.add(c);
        });
        JButton addDropDownButton = DropDownButtonFactory.createDropDownButton(Icons.ADD, popupMenu);
        addDropDownButton.setPreferredSize(new Dimension(40, addDropDownButton.getPreferredSize().height));
        addDropDownButton.setToolTipText("Create New Alert");
        return addDropDownButton;
    }

    static {
        BufferedImage folderImg = ImageUtil.loadImageResource(Icons.class, (String)"mdi_folder-open.png");
        FOLDER = new ImageIcon(folderImg);
    }

    public static interface OnRemove {
        public void elementRemoved(JComponent var1);
    }

    public static interface ButtonClickListener {
        public void clickPerformed(JButton var1, int var2);
    }
}

